package com.qkdata.biz.web.controller;

import com.google.common.base.Strings;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.sys.service.ShiroService;
import com.qkdata.biz.sys.vo.LoginUserInfo;
import com.qkdata.biz.web.vo.FullUserInfo;
import com.qkdata.biz.web.vo.LoginByCodeModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.constants.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "用户端登陆")
@RestController
@RequestMapping("/api/web/login")
public class LoginController {
    @Autowired
    private ShiroService shiroService;


    @ApiOperation("手机号+验证码登陆")
    @PostMapping("/loginByCode")
    @SysLog(value = "手机号+验证码登陆",includeParam = false)
    public Result<FullUserInfo> loginByCode(@RequestBody @Validated LoginByCodeModel model){

        return Result.succeed(shiroService.loginByCode(model));
    }
}
