package com.qkdata.biz.management.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.qkdata.biz.enums.ProductTypeEnum;
import com.qkdata.biz.management.entity.OrgSurplusPO;
import com.qkdata.biz.management.entity.OrgUserReceiveRecordPO;
import com.qkdata.biz.management.mapper.OrgUserReceiveRecordMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.web.vo.EnterpriseAssignVipModel;
import com.qkdata.biz.web.vo.OrgUserReceiveRecordModel;
import com.qkdata.biz.web.vo.QueryReceiveHistoryModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.util.UserContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 企业成员领用或分配记录 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-06-03
 */
@Service
public class OrgUserReceiveRecordService extends ServiceImpl<OrgUserReceiveRecordMapper, OrgUserReceiveRecordPO> {

    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private OrgSurplusService orgSurplusService;
    @Autowired
    private UserCourseAuthService userCourseAuthService;

    public PageResult<OrgUserReceiveRecordModel> queryPageList(QueryReceiveHistoryModel model) {
        Page page = new Page(model.getPageIndex(),model.getPageSize());
        List<OrgUserReceiveRecordModel> list = baseMapper.queryPageList(page,model);
        return PageResult.<OrgUserReceiveRecordModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    /**
     * 企业分配VIP
     * @param models
     */
    @Transactional
    public void assignVip(List<EnterpriseAssignVipModel> models) {
        Long orgId = sysUserService.getUserEnterpriesId(UserContext.getUserId());
        List<OrgUserReceiveRecordPO> poList = Lists.newArrayList();
        for (EnterpriseAssignVipModel model : models){
            OrgUserReceiveRecordPO po = new OrgUserReceiveRecordPO();
            po.setOrgId(orgId);
            po.setUserId(model.getUserId());
            po.setProductType(model.getProductType());
            po.setCount(model.getCount());
            po.setCourseId(model.getCourseId());
            poList.add(po);
        }
        saveBatch(poList);
        validateAndSave(poList);
        addUserCourseAuth(poList);
    }

    /**
     * 分配企业课程时，添加用户课程授权记录
     * @param poList
     */
    private void addUserCourseAuth(List<OrgUserReceiveRecordPO> poList) {
        for (OrgUserReceiveRecordPO po : poList){
            if (po.getProductType() == ProductTypeEnum.ENTERPRISE_COURSE_BUY){
                userCourseAuthService.updateAuth(po.getUserId(),po.getCourseId(), LocalDateTime.now());
            }
        }
    }

    public synchronized void validateAndSave(List<OrgUserReceiveRecordPO> poList){
        for (OrgUserReceiveRecordPO po : poList){
            OrgSurplusPO orgSurplusPO = null;
            if (po.getProductType() == ProductTypeEnum.ENTERPRISE_VIP){
                //查询企业剩除数量
                orgSurplusPO = orgSurplusService.getVIP(po.getOrgId());
            }else if (po.getProductType() == ProductTypeEnum.ENTERPRISE_COURSE_BUY){
                orgSurplusPO = orgSurplusService.getCourseVIP(po.getOrgId(),po.getCourseId());
            }
            if (orgSurplusPO != null){
                if (orgSurplusPO.getCount() >= po.getCount()){
                    orgSurplusPO.setCount(orgSurplusPO.getCount() - po.getCount());
                    //更新剩余数量
                    orgSurplusService.updateById(orgSurplusPO);
                    //保存记录
                    save(po);
                }else {
                    throw new BusinessException("已超出剩余数量");
                }
            }
        }
    }
}