package com.qkdata.biz.management.controller;


import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.entity.RecommendConfigPO;
import com.qkdata.biz.management.service.CourseService;
import com.qkdata.biz.management.service.RecommendConfigService;
import com.qkdata.biz.management.vo.CourseListItemModel;
import com.qkdata.biz.management.vo.QueryCourseModel;
import com.qkdata.biz.management.vo.RecommendConfigModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 推荐课程配置 前端控制器
 * </p>
 *
 * @author liuyang
 * @since 2021-05-27
 */
@Api(tags = "首页推荐配置")
@RestController
@RequestMapping("/api/mgr/recommendConfig")
public class RecommendConfigController {

    @Autowired
    private RecommendConfigService configService;
    @Autowired
    private CourseService courseService;

    @ApiOperation("待选课程列表")
    @PostMapping("/select")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("待选课程列表")
    public PageResult<CourseListItemModel> select(@RequestBody QueryCourseModel model){
        List<RecommendConfigPO> list = configService.list();
        List<Long> courseIds = list.stream().map(RecommendConfigPO::getCourseId).collect(Collectors.toList());
        model.setNotInIdList(courseIds);
        return courseService.queryPageList(model);
    }

    @ApiOperation("获取推荐列表")
    @GetMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("获取推荐列表")
    public Result<List<RecommendConfigModel>> list(){
        return Result.succeed(configService.listConfig());
    }

    @ApiOperation("添加推荐")
    @PostMapping("/add")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("添加推荐")
    public Result<String> add(@RequestBody List<RecommendConfigPO> list){
        for (RecommendConfigPO po : list){
            configService.save(po);
        }
        return Result.succeed("ok");
    }
    @ApiOperation("删除推荐")
    @GetMapping("/delete/{id}")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("删除推荐")
    public Result<String> delete(@PathVariable Long id){
        configService.removeById(id);
        return Result.succeed("ok");
    }
}
