package com.qkdata.common.converter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

/**
 * 用于QUERY参数转换成LocalDateTime
 */
public class StringToLocalDateTimeConverter implements Converter<String, LocalDateTime> {

    @Override
    public LocalDateTime convert(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }

        return Instant.ofEpochMilli(Long.valueOf(source)).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}
