package com.qkdata.biz.web.controller;

import com.aliyuncs.vod.model.v20170321.GetVideoPlayAuthResponse;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.enums.SwiperStatusEnum;
import com.qkdata.biz.management.entity.CourseTagPO;
import com.qkdata.biz.management.service.CourseService;
import com.qkdata.biz.management.service.CourseTagService;
import com.qkdata.biz.management.service.RecommendConfigService;
import com.qkdata.biz.management.service.SwiperConfigService;
import com.qkdata.biz.management.vo.CourseDetailModel;
import com.qkdata.biz.management.vo.SwiperConfigModel;
import com.qkdata.biz.web.service.UserCenterService;
import com.qkdata.biz.web.vo.MainPageModel;
import com.qkdata.biz.web.vo.SaveFavoriteCourseModel;
import com.qkdata.biz.web.vo.SearchCourseConditionModel;
import com.qkdata.biz.web.vo.SearchCourseResultModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "首页数据获取")
@RestController
@RequestMapping("/api/web/mainPage")
public class MainPageController {
    @Autowired
    private SwiperConfigService swiperConfigService;
    @Autowired
    private CourseTagService courseTagService;
    @Autowired
    private RecommendConfigService recommendConfigService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private CourseTagService tagService;
    @Autowired
    private UserCenterService userCenterService;

    @ApiOperation("获取配置信息")
    @GetMapping("")
    public Result<MainPageModel> get(){
        List<SwiperConfigModel> swiperConfigModels = swiperConfigService.listConfig(SwiperStatusEnum.ENABLE);
        List<CourseTagPO> tagList = courseTagService.list(Wrappers.<CourseTagPO>lambdaQuery().eq(CourseTagPO::getRecommend,true));
        MainPageModel model = new MainPageModel();
        model.setTags(tagList);
        model.setSwiperConfigs(swiperConfigModels);

        return Result.succeed(model);
    }
    @ApiOperation("首页推存课程列表")
    @PostMapping("/course/recommend/list")
    public PageResult<SearchCourseResultModel> recommendCourseList(@RequestBody SearchCourseConditionModel model){
        return courseService.mainPageRecommendList(model);
    }

    @ApiOperation("搜索课程")
    @PostMapping("/course/search")
    @SysLog("搜索课程")
    public PageResult<SearchCourseResultModel> searchCourse(@RequestBody SearchCourseConditionModel model){
        return courseService.search(model);
    }

    @ApiOperation("获取全部标签")
    @GetMapping("/course/tags")
    public Result<List<CourseTagPO>> findCourseTags(){
        List<CourseTagPO> tags = tagService.list();
        return Result.succeed(tags);
    }

    @ApiOperation("详情页关联课程推荐")
    @GetMapping("/course/recommend/{courseId}")
    public Result<List<SearchCourseResultModel>> courseRecommend(Long courseId){
        List<SearchCourseResultModel> list = courseService.relationRecommend(courseId);
        return Result.succeed(list);
    }

    @ApiOperation("获取课程详情")
    @GetMapping("/course/{id}")
    @SysLog("获取课程详情")
    public Result<CourseDetailModel> getCourseDetail(@PathVariable Long id){
        courseService.checkPerm(id);
        CourseDetailModel model = courseService.getCourseDetail(id);
        return Result.succeed(model);
    }
    @ApiOperation("收藏课程")
    @PostMapping("/course/favorite")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("收藏课程")
    public Result<String> favoriteCourse(@RequestBody SaveFavoriteCourseModel model){
        userCenterService.favoriteCourse(model.getCourseId());
        return Result.succeed("ok");
    }
    @ApiOperation("取消收藏")
    @PostMapping("/course/removeFavorite")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("取消收藏")
    public Result<String> removeFavoriteCourse(@RequestBody SaveFavoriteCourseModel model){
        userCenterService.removeFavoriteCourse(model.getCourseId());
        return Result.succeed("ok");
    }


    @ApiOperation("获取视频播放凭证")
    @GetMapping("/course/playVideo")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("获取视频播放凭证")
    public Result<GetVideoPlayAuthResponse> getCoursePlayVideoUrl(@RequestParam Long courseId,@RequestParam Long chaperId){
        //验证权限
        userCenterService.checkCoursePlayPerm(courseId,chaperId);
        GetVideoPlayAuthResponse response = courseService.getVideoPlayAuth(courseId,chaperId);

        return Result.succeed(response);
    }
}
