package com.qkdata.biz.management.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.qkdata.biz.enums.*;
import com.qkdata.common.base.entity.BasePO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 课程
 * </p>
 *
 * @author liuyang
 * @since 2021-05-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("course")
public class CoursePO extends BasePO {

    private static final long serialVersionUID = 1L;

    /**
     * 课程类型（单集、系列）
     */
    private CourseTypeEnum type;

    /**
     * 课程名称
     */
    private String name;

    /**
     * 课程简介
     */
    private String introduce;
    /**
     * 课程介绍
     */
    private String detail;

    /**
     * 课程封面url
     */
    private String logoUrl;

    /**
     * 状态（上架、下架）
     */
    private CourseStatusEnum status;

    /**
     * 讲师ID
     */
    private Long teacherId;

    /**
     * 收费模式（免费、会员免费、付费点播）
     */
    private CourseChargeModelEnum chargeModel;

    /**
     * 付费点播普通用户价
     */
    private BigDecimal price;

    /**
     * 付费点播会员价
     */
    private BigDecimal vipPrice;

    /**
     * 有效时间（小时）
     */
    private Integer validPeriod;

    /**
     * 课程形态（点播、直播、一对一）
     */
    private CourseModelEnum model;

    /**
     * 系列ID
     */
    private Long seriesId;

    /**
     * 可见范围（全部、指定企业）
     */
    private CourseAllowEnum allow;

    /**
     * 删除标识
     */
    @TableLogic
    private Boolean isDel;


}
