package com.qkdata.biz.sys.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.qkdata.biz.enums.AccountStatusEnum;
import com.qkdata.biz.enums.AccountTypeEnum;
import com.qkdata.biz.sys.entity.SysUserExtPO;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.mapper.SysUserExtMapper;
import com.qkdata.biz.sys.mapper.SysUserMapper;
import com.qkdata.biz.sys.vo.QueryUserModel;
import com.qkdata.biz.sys.vo.SysRoleModel;
import com.qkdata.biz.sys.vo.SysUserListModel;
import com.qkdata.biz.sys.vo.SysUserModel;
import com.qkdata.biz.web.vo.FullUserInfo;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import com.qkdata.common.util.UserContext;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.tomcat.jni.Local;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.List;

@Service
public class SysUserService extends BaseServiceImpl<SysUserMapper, SysUserPO> {
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysUserExtMapper sysUserExtMapper;

    public SysUserPO getByUsername(String username) {
        return baseMapper.selectOne(Wrappers.<SysUserPO>lambdaQuery().eq(SysUserPO::getUsername,username));
    }

    public List<String> queryAllPerms(Long userId) {
        return baseMapper.queryAllPerms(userId);
    }

    public PageResult<SysUserListModel> queryPageList(QueryUserModel queryUserModel) {
        Page<SysUserListModel> page = new Page<>(queryUserModel.getPageIndex(),queryUserModel.getPageSize());
        List<SysUserListModel> pageList = baseMapper.queryPageList(page,queryUserModel);
        for (SysUserListModel sysUser : pageList){
            List<SysRoleModel> roles = sysRoleService.getUserRoles(sysUser.getId());
            sysUser.setRoleIdList(roles);
        }
        return PageResult.<SysUserListModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(pageList).build();
    }

    public List<Long> queryRoleIdList(Long userId) {
        return sysUserRoleService.queryRoleIdList(userId);
    }

    @Transactional
    public Long saveUser(SysUserModel sysUserModel) {
        SysUserPO po = getByUsername(sysUserModel.getUsername());
        if (po != null){
            throw new BusinessException("帐号已存在");
        }
        po = new SysUserPO();
        BeanUtils.copyProperties(sysUserModel,po);
        po.setSalt(RandomStringUtils.randomAlphanumeric(20));
        po.setPassword(new Sha256Hash(sysUserModel.getPassword(), po.getSalt()).toHex());
        po.setLastLoginTime(LocalDateTime.now());
        po.setStatus(sysUserModel.getStatus() != null ? sysUserModel.getStatus() : AccountStatusEnum.UNACTIVATE);
        save(po);
        List<Long> roleIds = null;
        if (CollUtil.isNotEmpty(sysUserModel.getRoleIdList())){
            roleIds = sysUserModel.getRoleIdList();
        }else {
            //默认为运营人员
            roleIds = Lists.newArrayList(2L);
        }
        sysUserRoleService.saveOrUpdateUserRole(po.getId(),roleIds);
        return po.getId();
    }

    @Transactional
    public Long updateUser(SysUserModel sysUserModel) {
        SysUserPO po = getById(sysUserModel.getId());
        if (po == null){
            throw new BusinessException("请求错误，用户不存在");
        }
        po.setStatus(sysUserModel.getStatus());
        po.setNickName(sysUserModel.getNickName());
        updateById(po);
        return po.getId();
//        sysUserRoleService.saveOrUpdateUserRole(po.getId(),sysUserModel.getRoleIdList());
    }

    public void updatePassword(SysUserPO user, String password, String newPassword) {
        //sha256加密
        String pwd = new Sha256Hash(password, UserContext.getUser().getSalt()).toHex();
        if (!user.getPassword().equals(pwd)){
            throw new BusinessException("原密码错误");
        }
        //sha256加密
        String newPwd = new Sha256Hash(newPassword, UserContext.getUser().getSalt()).toHex();
        user.setPassword(newPwd);
        updateById(user);
    }

    @Transactional
    public void removeUsers(List<Long> ids) {
        removeByIds(ids);
        sysUserRoleService.deleteByUserIds(ids);
    }

    public FullUserInfo findFullUserInfo(String username) {
        return baseMapper.selectFullUserInfo(username);
    }

    public void registerUser(String mobile) {
        SysUserPO userPo = new SysUserPO();
        userPo.setUsername(mobile);
        userPo.setStatus(AccountStatusEnum.ENABLE);
        userPo.setActivateTime(LocalDateTime.now());
        save(userPo);
        List<Long> roleIds = Lists.newArrayList(5L);
        sysUserRoleService.saveOrUpdateUserRole(userPo.getId(),roleIds);
        SysUserExtPO extUser = new SysUserExtPO();
        extUser.setUserId(userPo.getId());
        extUser.setType(AccountTypeEnum.USER);
        sysUserExtMapper.insert(extUser);
    }
}
