package com.qkdata.biz.management.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.management.entity.CourseTagPO;
import com.qkdata.biz.management.mapper.CourseTagMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.management.vo.QueryCourseTagModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.model.PageResult;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * $!{table.comment} 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-05-14
 */
@Service
public class CourseTagService extends ServiceImpl<CourseTagMapper, CourseTagPO> {

    public PageResult<CourseTagPO> queryPageList(QueryCourseTagModel param) {
        Page page = new Page(param.getPageIndex(),param.getPageSize());
        List<CourseTagPO> pageList = baseMapper.queryPageList(page,param);
        return PageResult.<CourseTagPO>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(pageList).build();
    }

    public List<CourseTagPO> findListByCourseId(Long courseId) {
        return baseMapper.selectListByCourseId(courseId);
    }
}