package com.qkdata.common.converter;

import cn.hutool.core.date.DateUtil;
import com.qkdata.common.base.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * 用于QUERY参数转换成Date
 */
@Slf4j
public class StringToDateConverter implements Converter<String, Date> {

    @Override
    public Date convert(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        try {
            return DateUtil.parseDateTime(source);
        } catch (Exception e) {
            log.warn("时间转换异常", e);
            throw new BusinessException("时间转换异常");
        }

    }
}
