package com.qkdata.biz.management.controller;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.entity.SwiperConfigPO;
import com.qkdata.biz.management.service.SwiperConfigService;
import com.qkdata.biz.management.vo.SwiperConfigModel;
import com.qkdata.biz.management.vo.SwiperLInkCourseModel;
import com.qkdata.biz.management.vo.SwiperModifyStatusModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 轮播图配置 前端控制器
 * </p>
 *
 * @author liuyang
 * @since 2021-05-27
 */
@Api(tags = "首页轮播图配置")
@RestController
@RequestMapping("/api/mgr/swiperConfig")
public class SwiperConfigController {
    @Autowired
    private SwiperConfigService swiperConfigService;

    @ApiOperation("获取轮播图配置")
    @GetMapping("")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("获取轮播图配置")
    public Result<List<SwiperConfigModel>> list(){
        List<SwiperConfigModel> list = swiperConfigService.listConfig(null);
        return Result.succeed(list);
    }
    @ApiOperation("添加轮播图")
    @PostMapping("/save")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("添加轮播图")
    public Result<Long> add(@RequestBody SwiperConfigPO po){
        swiperConfigService.saveOrUpdate(po);
        return  Result.succeed(0L);
    }
    @ApiOperation("关联课程")
    @PostMapping("/linkCourse")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("关联课程")
    public Result<String> linkCourse(@RequestBody SwiperLInkCourseModel model){
        swiperConfigService.linkCourse(model);
        return Result.succeed("ok");
    }
    @ApiOperation("修改状态")
    @PostMapping("/modifyStatus")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("修改状态")
    public Result<String> modifyStatus(@RequestBody SwiperModifyStatusModel model){
        swiperConfigService.modifyStatus(model);
        return Result.succeed("ok");
    }
    @ApiOperation("删除配置")
    @GetMapping("/remove/{id}")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("删除配置")
    public Result<String> remove(@PathVariable Long id){
        swiperConfigService.removeById(id);
        return Result.succeed("ok");
    }

}
