package com.qkdata.biz.web.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.enums.AccountStatusEnum;
import com.qkdata.biz.enums.AccountTypeEnum;
import com.qkdata.biz.enums.OrgTypeEnum;
import com.qkdata.biz.enums.ProductTypeEnum;
import com.qkdata.biz.management.entity.OrgSurplusPO;
import com.qkdata.biz.management.entity.OrganizationPO;
import com.qkdata.biz.management.service.*;
import com.qkdata.biz.management.vo.*;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.web.vo.*;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Api(tags = "我的企业相关接口-手机端")
@RestController
@RequestMapping("/api/myEnterPrise")
public class MyEnterpriseController {
    @Autowired
    private OrganizationService orgService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private OrgSurplusService orgSurplusService;
    @Autowired
    private OrgUserReceiveRecordService orgUserReceiveRecordService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private ProductOrderService orderService;

    @ApiOperation("获取我的企业信息")
    @GetMapping("/info")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("获取我的企业信息")
    public Result<OrganizationPO> info(){
        FullUserInfo userInfo = userService.findFullUserInfo(UserContext.getUser().getUsername());
        if (userInfo.getType() != AccountTypeEnum.ENTERPRISE_VIP || userInfo.getEnterpriseId() == null){
            throw new BusinessException("您目前还不是企业会员");
        }
        OrganizationPO po = orgService.getById(userInfo.getEnterpriseId());
        if (po == null){
            throw new BusinessException("请求错误，企业信息不存在");
        }
        return Result.succeed(po);
    }

    @ApiOperation("获取企业课程列表")
    @PostMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("获取企业课程列表")
    public PageResult<SearchCourseResultModel> list(@RequestBody QueryMyEnterpriseCourseModel model){
        FullUserInfo userInfo = userService.findFullUserInfo(UserContext.getUser().getUsername());
        if (userInfo.getType() != AccountTypeEnum.ENTERPRISE_VIP || userInfo.getEnterpriseId() == null){
            throw new BusinessException("请求错误，当前用户非企业用户");
        }
        return courseService.queryPageListByEnterprise(model);
    }
    @ApiOperation("获取企业会员余额")
    @GetMapping("/orgSurplus")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("获取企业会员余额")
    public Result<OrgSurplusPO> getOrgSurplus(){
        Long orgId = userService.getUserEnterpriesId(UserContext.getUserId());
        OrgSurplusPO result = orgSurplusService.getOne(Wrappers.<OrgSurplusPO>lambdaQuery().eq(OrgSurplusPO::getOrgId,orgId).eq(OrgSurplusPO::getProductType,ProductTypeEnum.ENTERPRISE_VIP));
        return Result.succeed(result);
    }
    @ApiOperation("获取企业购买课程余额列表")
    @PostMapping("/orgCourseSurplus")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("获取企业购买课程余额列表")
    public PageResult<OrgCourseSurplusModel> orgCourseSurplusList(@RequestBody QueryOrgCourseSurplusModel model){
        Long orgId = userService.getUserEnterpriesId(UserContext.getUserId());
        model.setOrgId(orgId);
        return orgSurplusService.queryCourseSurplusPageList(model);
    }
    @ApiOperation("领取会员")
    @GetMapping("/receiveVIP")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("领取会员")
    public Result<String> receiveVIP(){
        userService.receiveOrgVIP();
        return Result.succeed("ok");
    }
    @ApiOperation("领取企业购买课程")
    @GetMapping("/receiveCourse/{courseId}")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("领取企业购买课程")
    public Result<String> receiveCourse(@PathVariable Long courseId){
        userService.receiveOrgCourse(courseId);
        return Result.succeed("ok");
    }
    @ApiOperation("领取会员历史记录列表")
    @PostMapping("/history/receiveVIP")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("领取会员历史记录列表")
    public PageResult<OrgUserReceiveRecordModel> receiveVIPHistory(@RequestBody QueryReceiveHistoryModel model){
        model.setUserId(UserContext.getUserId());
        return orgUserReceiveRecordService.queryPageList(model);
    }


    @ApiOperation("修改企业信息")
    @PostMapping("/info/update")
    @RequiresRoles(value = BizConstants.ROLE_ENTERPRISE_ADMIN)
    @SysLog("修改企业信息")
    public Result<String> updateOrgInfo(@RequestBody OrganizationPO orgInfo){
        orgService.updateById(orgInfo);
        return Result.succeed("ok");
    }
    @ApiOperation("企业成员列表")
    @PostMapping("/member/list")
    @RequiresRoles(value = BizConstants.ROLE_ENTERPRISE_ADMIN)
    @SysLog("企业成员列表")
    public PageResult<MemberListModel> memberList(@RequestBody QueryMemberModel model){
        if (model.getOrgId() == null){
            throw new BusinessException("请求参数错误，企业ID不能为空");
        }
        return memberService.queryPage(model);
    }
    @ApiOperation("获取企业成员详情")
    @GetMapping("/memeber/detail")
    @RequiresRoles(value = BizConstants.ROLE_ENTERPRISE_ADMIN)
    @SysLog("获取企业成员详情")
    public Result<MemberInfoModel> memberDetail(@RequestParam String username){
        MemberInfoModel memberInfo = memberService.getByUsername(username,true);
        return Result.succeed(memberInfo);
    }
    @ApiOperation("企业成员领取记录")
    @GetMapping("/member/receive/record")
    @RequiresRoles(value = BizConstants.ROLE_ENTERPRISE_ADMIN)
    @SysLog("企业成员领取记录")
    public PageResult<OrgUserReceiveRecordModel> memberReceiveRecord(@RequestParam Long memberId){
        QueryReceiveHistoryModel query = new QueryReceiveHistoryModel();
        query.setUserId(memberId);
        return orgUserReceiveRecordService.queryPageList(query);
    }

    @ApiOperation("获取企业会员、点播库领取配置")
    @GetMapping("/receiveConfig")
    @RequiresRoles(value = BizConstants.ROLE_ENTERPRISE_ADMIN)
    @SysLog("获取企业会员、点播库领取配置")
    public Result<EnterpriesReceiveConfig> receiveConfig(){
        EnterpriesReceiveConfig config = new EnterpriesReceiveConfig();
        Long userId = UserContext.getUserId();
        Long orgId = userService.getUserEnterpriesId(userId);
        OrganizationPO po = orgService.getById(orgId);
        if (po != null && po.getType() == OrgTypeEnum.ENTERPRISE){
            config.setVipReceive(po.getVipReceive());
            config.setCourseReceive(po.getCourseReceive());
        }
        return Result.succeed(config);
    }
    @ApiOperation("修改企业会员、点播库领取配置")
    @GetMapping("/receiveConfig/save")
    @RequiresRoles(value = BizConstants.ROLE_ENTERPRISE_ADMIN)
    @SysLog("修改企业会员、点播库领取配置")
    public Result<String> receiveConfigSave(@RequestBody EnterpriesReceiveConfig model){
        EnterpriesReceiveConfig config = new EnterpriesReceiveConfig();
        Long userId = UserContext.getUserId();
        Long orgId = userService.getUserEnterpriesId(userId);
        OrganizationPO po = orgService.getById(orgId);
        if (po != null && po.getType() == OrgTypeEnum.ENTERPRISE){
            po.setVipReceive(model.getVipReceive());
            po.setCourseReceive(model.getCourseReceive());
            orgService.updateById(po);
        }
        return Result.succeed("ok");
    }

    @ApiOperation("企业购买记录列表")
    @PostMapping("/order/list")
    @RequiresRoles(value = {BizConstants.ROLE_ENTERPRISE_ADMIN})
    @SysLog("企业购买记录列表")
    public PageResult<ProductOrderModel> userOrderList(@RequestBody QueryProductOrderModel model){
        model.setEnterprise(true);
        model.setOrgId(userService.getUserEnterpriesId(UserContext.getUserId()));
        return orderService.queryPageList(model);
    }
    @ApiOperation("添加企业成员")
    @PostMapping("/member/add")
    @RequiresRoles(value = {BizConstants.ROLE_ENTERPRISE_ADMIN})
    @SysLog("添加企业成员")
    public Result<String> addMember(@RequestBody @Validated AddMemberModel model){
        Long orgId = userService.getUserEnterpriesId(UserContext.getUserId());
        MemberInfoModel memberInfo = new MemberInfoModel();
        memberInfo.setUsername(model.getMobile());
        memberInfo.setName(model.getName());
        memberInfo.setEnterpriseId(orgId);
        memberInfo.setType(AccountTypeEnum.ENTERPRISE_VIP);
        List<String> roleCodeList = Lists.newArrayList(BizConstants.ROLE_USER);
        memberInfo.setRoleCodeList(roleCodeList);
        memberService.save(memberInfo);
        return Result.succeed("ok");
    }
    @ApiOperation("删除成员")
    @GetMapping("/member/delete")
    @RequiresRoles(value = {BizConstants.ROLE_ENTERPRISE_ADMIN})
    @SysLog("删除成员")
    public Result<String> deleteMember(@RequestParam Long userId){
        //todo
        return Result.succeed("ok");
    }

}
