package com.qkdata.biz.management.controller;


import com.qkdata.biz.management.service.ResourceService;
import com.qkdata.biz.management.vo.ResourceModel;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * <p>
 * 资源 前端控制器
 * </p>
 *
 * @author liuyang
 * @since 2021-04-30
 */
@Api(tags = "资源管理")
@RestController
@RequestMapping("/api/mgr/resource")
public class ResourceController {

    @Autowired
    private ResourceService resourceService;

    @ApiOperation("上传文件")
    @PostMapping("/uploadFile")
    public Result<ResourceModel> uploadFile(@RequestParam("file")MultipartFile file){
        if (file.isEmpty()){
            throw new BusinessException("请求错误，文件不存在");

        }
        return Result.succeed(resourceService.uploadFile(file));

    }

}
