package com.qkdata.alipay.service;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.*;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.qkdata.alipay.config.AlipayProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;


@Slf4j
@Service
public class AlipayService {
    @Autowired
    private AlipayProperties alipayProperties;
    @Value("${frontend.domain}")
    private String frontendDomain;
    private AlipayClient alipayClient;

    @PostConstruct
    public void init(){
        alipayClient = new DefaultAlipayClient(alipayProperties.getUrl(),
                alipayProperties.getAppId(),
                alipayProperties.getAppPrivateKey(),
                AlipayConstants.FORMAT_JSON,
                AlipayConstants.CHARSET_UTF8,
                alipayProperties.getAlipayPublicKey(),
                AlipayConstants.SIGN_TYPE_RSA2);

    }
    public String prePayOrder(AlipayTradeWapPayModel model) throws AlipayApiException {
        AlipayTradeWapPayRequest alipay_request=new AlipayTradeWapPayRequest();
        alipay_request.setBizModel(model);
        alipay_request.setNotifyUrl(frontendDomain + "/online-edu-backend/alipay/notify/order");
        alipay_request.setReturnUrl(model.getQuitUrl()+"&result=true");
        String form = "";
        AlipayTradeWapPayResponse response = alipayClient.pageExecute(alipay_request);
        if (response.isSuccess()){
            form = response.getBody();
        }else {
            log.info("Alipay prePay request faild:"+ JSONObject.toJSONString(response));
        }
        return form;
    }

    public String queryOrder(String orderNo) throws AlipayApiException {
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(orderNo);
        request.setBizModel(model);
        AlipayTradeQueryResponse response = alipayClient.execute(request);
        String result = "";
        if (response.isSuccess()){
            result = response.getTradeStatus();
        }else {
            log.info("Alipay trade query faild:"+JSONObject.toJSONString(response));
        }
        return result;
    }
}
