package com.qkdata.biz.management.vo;

import com.qkdata.biz.enums.PayMethodEnum;
import com.qkdata.biz.enums.ProductOrderStatusEnum;
import com.qkdata.biz.enums.ProductTypeEnum;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ProductOrderModel {
    private Long id;
    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 订单名称
     */
    private String orderName;

    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 用户昵称
     */
    private String nickName;
    /**
     * 用户手机号
     */
    private String username;
    /**
     * 用户身份
     */
    private String userRoleName;

    /**
     * 产品类型（个人包月、企业包月、付费点播）
     */
    private ProductTypeEnum productType;

    /**
     * 课程ID
     */
    private Long courseId;

    /**
     * 产品单价
     */
    private BigDecimal productPrice;

    /**
     * 产品购买数量
     */
    private Integer productCount;

    /**
     * 订单金额
     */
    private BigDecimal orderMoney;

    /**
     * 支付金额
     */
    private BigDecimal paymentMoney;

    /**
     * 支付方式（微信、支付宝）
     */
    private PayMethodEnum payMethod;

    /**
     * 订单状态
     */
    private ProductOrderStatusEnum status;
    /**
     * 订单创建时间
     */
    private LocalDateTime createTime;
    /**
     * 订单支付完成时间
     */
    private LocalDateTime updateTime;
}
