package com.qkdata.common.trace;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class TraceLog implements Serializable {


    /**
     * traceId
     */
    private String traceId;

    /**
     * 请求路径
     */
    private String path;

    /**
     * 请求方法
     */
    private String method;

    /**
     * 请求头信息
     */
    private String headers;

    /**
     * query请求参数
     */
    private String parameters;

    /**
     * 接口花费时间
     */
    private Long timeTaken;

    /**
     * 日志创建时间
     */
    private LocalDateTime createAt;

    /**
     * Response Status
     */
    private Integer status;

    /**
     * 请求Body
     */
    private String requestBody;

    /**
     * 响应Body
     */
    private String responseBody;
}
