package com.qkdata.biz.management.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.enums.AccountTypeEnum;
import com.qkdata.biz.enums.OrgTypeEnum;
import com.qkdata.biz.management.entity.OrganizationPO;
import com.qkdata.biz.management.mapper.OrganizationMapper;
import com.qkdata.biz.management.vo.*;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.service.SysRoleService;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.sys.vo.SysRoleModel;
import com.qkdata.common.base.entity.BasePO;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * <p>
 * $!{table.comment} 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-04-27
 */
@Service
public class OrganizationService extends BaseServiceImpl<OrganizationMapper, OrganizationPO> {
    @Autowired
    private MemberService memberService;
    @Autowired
    private SysRoleService sysRoleService;

    @Override
    public boolean save(OrganizationPO po) {
        OrganizationPO dbPO = getByName(po.getName());
        if (dbPO != null && dbPO.getType() == po.getType()) {
            throw new BusinessException("该机构名称已存在");
        }
        return super.save(po);
    }

    private OrganizationPO getByName(String name) {
        return baseMapper.selectOne(Wrappers.<OrganizationPO>lambdaQuery().eq(OrganizationPO::getName, name));
    }

    @Override
    public boolean updateById(OrganizationPO po) {
        OrganizationPO dbPO = baseMapper.selectOne(Wrappers.<OrganizationPO>lambdaQuery().eq(OrganizationPO::getName, po.getName())
                .eq(OrganizationPO::getType,po.getType())
                .ne(BasePO::getId, po.getId()));
        if (dbPO != null){
            throw new BusinessException("该机构名称已存在");
        }
        dbPO = getById(po.getId());
        if (dbPO == null){
            throw new BusinessException("请求错误，数据不存在");
        }
        return super.updateById(po);
    }


    public PageResult<OrganizationPO> queryPageList(QueryOrgModel param) {
        Page page = new Page(param.getPageIndex(),param.getPageSize());
        List<OrganizationPO> pageList = baseMapper.queryPageList(page,param);
        return PageResult.<OrganizationPO>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(pageList).build();
    }

    public PageResult<EnterpriseListItemModel> queryEnterprisePageList(QueryEnterpriseModel param) {
        Page page = new Page(param.getPageIndex(),param.getPageSize());
        List<EnterpriseListItemModel> list = baseMapper.queryEnterprisePageList(page,param);
        //TODO 获取成员数量
        return PageResult.<EnterpriseListItemModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    @Transactional
    public void saveEnterprise(EnterpriseModel model) {
        //验证管理员手机号是否被占用
        if (memberService.isEnterpriseAdminUser(model.getAdminMobile())){
            throw new BusinessException("该手机号已是其它企业管理员");
        }

        //保存企业信息
        Long enterpriseId = savePO(model);
        //创建企业管理员帐号
        MemberInfoModel memberInfoModel = memberService.getByUsername(model.getAdminMobile(),false);
        if (memberInfoModel != null){
            //更新帐号信息和角色
            MemberInfoModel updateModel = new MemberInfoModel();
            updateModel.setId(memberInfoModel.getId());
            updateModel.setName(model.getAdminName());
            updateModel.setNickName(model.getAdminNickName());
            updateModel.setEnterpriseId(enterpriseId);
            List<String> roleCodeList = Lists.newArrayList(BizConstants.ROLE_ENTERPRISE_ADMIN);
            updateModel.setRoleCodeList(roleCodeList);
            memberService.update(updateModel);
        }else {
            //创建帐号信息和角色
            MemberInfoModel saveModel = new MemberInfoModel();
            saveModel.setUsername(model.getAdminMobile());
            saveModel.setNickName(model.getAdminNickName());
            saveModel.setName(model.getAdminName());
            saveModel.setEnterpriseId(enterpriseId);
            saveModel.setType(AccountTypeEnum.USER);
            List<String> roleCodeList = Lists.newArrayList(BizConstants.ROLE_ENTERPRISE_ADMIN);
            saveModel.setRoleCodeList(roleCodeList);
            memberService.save(saveModel);
        }
    }

    private Long savePO(EnterpriseModel model) {
        OrganizationPO po = new OrganizationPO();
        po.setName(model.getName());
        po.setType(OrgTypeEnum.ENTERPRISE);
        po.setLogoUrl(model.getLogoUrl());
        po.setProvince(model.getProvince());
        po.setCity(model.getCity());
        po.setAddress(model.getAddress());
        save(po);
        return po.getId();
    }

    public void updateEnterprise(EnterpriseModel model) {
        OrganizationPO po = getById(model.getId());
        if (po == null){
            throw new BusinessException("企业信息不存在");
        }
        po.setName(model.getName());
        po.setLogoUrl(model.getLogoUrl());
        po.setProvince(model.getProvince());
        po.setCity(model.getCity());
        po.setAddress(model.getAddress());
        updateById(po);
    }
}