package com.qkdata.biz.management.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.enums.AccountStatusEnum;
import com.qkdata.biz.management.vo.MemberInfoModel;
import com.qkdata.biz.sys.entity.SysRolePO;
import com.qkdata.biz.sys.entity.SysUserExtPO;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.mapper.SysUserExtMapper;
import com.qkdata.biz.sys.service.SysRoleService;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.management.vo.MemberListModel;
import com.qkdata.biz.management.vo.QueryMemberModel;
import com.qkdata.biz.sys.vo.SysRoleModel;
import com.qkdata.biz.sys.vo.SysUserModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.constants.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class MemberService {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserExtMapper sysUserExtMapper;
    @Autowired
    private SysRoleService sysRoleService;

    public PageResult<MemberListModel> queryPage(QueryMemberModel param) {
        Page page = new Page(param.getPageIndex(),param.getPageSize());
        List<MemberListModel> list = sysUserExtMapper.queryPage(page,param);
        return PageResult.<MemberListModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    public boolean isEnterpriseAdminUser(String adminMobile) {
        boolean flag = false;
        SysUserPO sysUserPO = sysUserService.getByUsername(adminMobile);
        if (sysUserPO != null){
            //帐号已存在时，验证该帐号是否已为企业管理员
            List<SysRoleModel> roles = sysRoleService.getUserRoles(sysUserPO.getId());
            if (CollUtil.isNotEmpty(roles)) {
                for (SysRoleModel role : roles) {
                    if (role.getCode().equals(BizConstants.ROLE_ENTERPRISE_ADMIN)) {
                        flag = true;
                        break;
                    }
                }
            }
        }
        return flag;
    }

    public MemberInfoModel getByUsername(String username) {
        return getByUsername(username,false);
    }
    public MemberInfoModel getByUsername(String username, boolean withRole) {
        MemberInfoModel model = sysUserExtMapper.getByUsername(username);
        if (withRole){
            List<SysRoleModel> roleList = sysRoleService.getUserRoles(model.getId());
            List<String> roleCodeList = roleList.stream().map(SysRoleModel::getCode).collect(Collectors.toList());
            model.setRoleCodeList(roleCodeList);
        }
        return model;
    }

    @Transactional
    public void save(MemberInfoModel model) {
        SysUserModel sysUserModel = convertToSysUserModel(model);
        Long userId = sysUserService.saveUser(sysUserModel);
        SysUserExtPO extUserPO = convertToExtUserPO(model);
        extUserPO.setUserId(userId);
        sysUserExtMapper.insert(extUserPO);
    }

    private SysUserExtPO convertToExtUserPO(MemberInfoModel model) {
        SysUserExtPO extUser = new SysUserExtPO();
        extUser.setName(model.getName());
        extUser.setSex(StrUtil.isNotBlank(model.getSex()) ? model.getSex() : null);
        extUser.setAge(model.getAge() != null ? model.getAge() : null);
        extUser.setAvatarUrl(StrUtil.isNotBlank(model.getAvatarUrl()) ? model.getAvatarUrl() : null);
        extUser.setEnterpriseId(model.getEnterpriseId() != null ? model.getEnterpriseId() : null);
        extUser.setType(model.getType() != null ? model.getType() : null);
        return extUser;
    }

    private SysUserModel convertToSysUserModel(MemberInfoModel model) {
        SysUserModel sysUserModel = new SysUserModel();
        sysUserModel.setId(model.getId() != null ? model.getId() : null);
        sysUserModel.setUsername(model.getUsername());
        sysUserModel.setPassword(StrUtil.isNotBlank(model.getPassword()) ? model.getPassword() : Constants.PSAAWORD);
        sysUserModel.setNickName(model.getNickName());
        sysUserModel.setStatus(model.getStatus() == null ? AccountStatusEnum.UNACTIVATE : model.getStatus());
        List<SysRolePO> roleList = sysRoleService.getByCodes(model.getRoleCodeList());
        List<Long> roleIds = Lists.newArrayList();
        if (CollUtil.isNotEmpty(roleList)){
            roleIds = roleList.stream().map(SysRolePO::getId).collect(Collectors.toList());
        }
        sysUserModel.setRoleIdList(roleIds);
        return sysUserModel;
    }

    public void update(MemberInfoModel model) {
        SysUserModel sysUserModel = convertToSysUserModel(model);
        Long userId = sysUserService.updateUser(sysUserModel);
        SysUserExtPO extUserPO = convertToExtUserPO(model);
        extUserPO.setUserId(userId);
        sysUserExtMapper.update(extUserPO, Wrappers.<SysUserExtPO>lambdaUpdate().eq(SysUserExtPO::getUserId,userId));
    }
}
