package com.qkdata.common.util;

import java.util.concurrent.ThreadLocalRandom;

/**
 * 随机数生成器
 */
public final class RandomDigitGenerator {

    private RandomDigitGenerator() {
    }

    private static final int DEFAULT_COUNT = 6;

    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();

    private static final int ORIGIN = 0;

    private static final int BOUND = 10;

    /**
     * 默认生成6位数字
     *
     * @return
     */
    public static String generate() {
        return generate(DEFAULT_COUNT);
    }

    /**
     * 生成指定长度的数字
     *
     * @param count 长度
     * @return
     */
    public static String generate(int count) {
        if (count <= 0 || count > 1000) {
            return "";
        }
        return RANDOM.ints(ORIGIN, BOUND)
                     .limit(count)
                     .collect(StringBuilder::new, StringBuilder::append, StringBuilder::append)
                     .toString();
    }

}
