package com.qkdata.biz.sys.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.sys.entity.SysConfigPO;
import com.qkdata.biz.sys.mapper.SysConfigMapper;
import com.qkdata.biz.sys.vo.QueryConfigModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

@Service
public class SysConfigService extends BaseServiceImpl<SysConfigMapper, SysConfigPO> {
    public PageResult<SysConfigPO> queryPageList(QueryConfigModel queryConfigModel) {
        Page<SysConfigPO> page = new Page<>(queryConfigModel.getPageIndex(),queryConfigModel.getPageSize());
        List<SysConfigPO> pageList = baseMapper.queryPageList(page,queryConfigModel);
        return PageResult.<SysConfigPO>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(pageList).build();
    }

    public void updateValueByKey(String key, String value) {
        SysConfigPO sysConfigPO = baseMapper.selectOne(Wrappers.<SysConfigPO>lambdaQuery().eq(SysConfigPO::getKey,key));
        if (sysConfigPO != null){
            sysConfigPO.setValue(value);
            updateById(sysConfigPO);
        }else {
            throw new BusinessException("不存的key");
        }
    }
}
