package com.qkdata.biz.management.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.management.entity.TeacherPO;
import com.qkdata.biz.management.mapper.TeacherMapper;
import com.qkdata.biz.management.vo.QueryTeacherModel;
import com.qkdata.biz.management.vo.TeacherModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * $!{table.comment} 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-05-18
 */
@Service
public class TeacherService extends ServiceImpl<TeacherMapper, TeacherPO> {

    private String defaultNo = "00001";
    private String codePrefix = "TH";

    public void saveModel(TeacherModel model) {
        TeacherPO po = new TeacherPO();
        BeanUtils.copyProperties(model,po);
        String dbMaxCode = findMaxNo();
        String teacherCode = getTeacherCode(dbMaxCode);
        po.setCode(teacherCode);
        super.save(po);
    }

    private String findMaxNo() {
        TeacherPO po = baseMapper.selectOne(Wrappers.<TeacherPO>lambdaQuery().orderByDesc(TeacherPO::getCode).last("limit 1"));
        if (po != null){
            return po.getCode();
        }
        return "";
    }

    private String getTeacherCode(String dbMaxCode){
        if (StrUtil.isNotBlank(dbMaxCode)){
            String noStr = StrUtil.sub(dbMaxCode,2,dbMaxCode.length());
            int no = Integer.parseInt(noStr);
            no++;
            String code = String.format("%05d",no);
            return StrUtil.format("{}{}",codePrefix,code);
        }
        return StrUtil.format("{}{}",codePrefix,defaultNo);
    }

    public void updateModel(TeacherModel model) {
        TeacherPO po = getById(model.getId());
        if (po == null){
            throw new BusinessException("讲师不存在");
        }
        po.setName(model.getName());
        po.setMobile(model.getMobile());
        po.setIntroduce(model.getIntroduce());
        po.setOrgId(model.getOrgId());
        updateById(po);
    }

    public PageResult<TeacherModel> queryPage(QueryTeacherModel param) {
        Page page = new Page(param.getPageIndex(),param.getPageSize());
        List<TeacherModel> list = baseMapper.queryPage(page,param);
        //TODO add courseCount

        return PageResult.<TeacherModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }
}