package com.qkdata.biz.web.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.enums.AccountTypeEnum;
import com.qkdata.biz.enums.ProductTypeEnum;
import com.qkdata.biz.management.entity.OrgSurplusPO;
import com.qkdata.biz.management.entity.OrganizationPO;
import com.qkdata.biz.management.service.CourseService;
import com.qkdata.biz.management.service.OrgSurplusService;
import com.qkdata.biz.management.service.OrgUserReceiveRecordService;
import com.qkdata.biz.management.service.OrganizationService;
import com.qkdata.biz.management.vo.MemberInfoModel;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.web.vo.*;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "我的企业相关接口-手机端")
@RestController
@RequestMapping("/api/myEnterPrise")
public class MyEnterpriseController {
    @Autowired
    private OrganizationService orgService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private OrgSurplusService orgSurplusService;
    @Autowired
    private OrgUserReceiveRecordService orgUserReceiveRecordService;

    @ApiOperation("获取我的企业信息")
    @GetMapping("/info")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<OrganizationPO> info(){
        FullUserInfo userInfo = userService.findFullUserInfo(UserContext.getUser().getUsername());
        if (userInfo.getType() != AccountTypeEnum.ENTERPRISE_VIP || userInfo.getEnterpriseId() == null){
            throw new BusinessException("您目前还不是企业会员");
        }
        OrganizationPO po = orgService.getById(userInfo.getEnterpriseId());
        if (po == null){
            throw new BusinessException("请求错误，企业信息不存在");
        }
        return Result.succeed(po);
    }

    @ApiOperation("获取企业课程列表")
    @PostMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public PageResult<SearchCourseResultModel> list(@RequestBody QueryMyEnterpriseCourseModel model){
        FullUserInfo userInfo = userService.findFullUserInfo(UserContext.getUser().getUsername());
        if (userInfo.getType() != AccountTypeEnum.ENTERPRISE_VIP || userInfo.getEnterpriseId() == null){
            throw new BusinessException("请求错误，当前用户非企业用户");
        }
        return courseService.queryPageListByEnterprise(model);
    }
    @ApiOperation("获取企业会员余额")
    @GetMapping("/orgSurplus")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<OrgSurplusPO> getOrgSurplus(){
        Long orgId = userService.getUserEnterpriesId(UserContext.getUserId());
        OrgSurplusPO result = orgSurplusService.getOne(Wrappers.<OrgSurplusPO>lambdaQuery().eq(OrgSurplusPO::getOrgId,orgId).eq(OrgSurplusPO::getProductType,ProductTypeEnum.ENTERPRISE_VIP));
        return Result.succeed(result);
    }
    @ApiOperation("获取企业购买课程余额列表")
    @PostMapping("/orgCourseSurplus")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public PageResult<OrgCourseSurplusModel> orgCourseSurplusList(@RequestBody QueryOrgCourseSurplusModel model){
        Long orgId = userService.getUserEnterpriesId(UserContext.getUserId());
        model.setOrgId(orgId);
        return orgSurplusService.queryCourseSurplusPageList(model);
    }
    @ApiOperation("领取会员")
    @GetMapping("/receiveVIP")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<String> receiveVIP(){
        userService.receiveOrgVIP();
        return Result.succeed("ok");
    }
    @ApiOperation("领取企业购买课程")
    @GetMapping("/receiveCourse/{courseId}")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<String> receiveCourse(@PathVariable Long courseId){
        userService.receiveOrgCourse(courseId);
        return Result.succeed("ok");
    }
    @ApiOperation("领取会员历史记录列表")
    @PostMapping("/history/receiveVIP")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public PageResult<OrgUserReceiveRecordModel> receiveVIPHistory(@RequestBody QueryReceiveHistoryModel model){
        model.setUserId(UserContext.getUserId());
        return orgUserReceiveRecordService.queryPageList(model);
    }


    @ApiOperation("修改企业信息")
    @PostMapping("/info/update")
    @RequiresRoles(value = BizConstants.ROLE_ENTERPRISE_ADMIN)
    public Result<String> updateOrgInfo(@RequestBody OrganizationPO orgInfo){
        orgService.updateById(orgInfo);
        return Result.succeed("ok");
    }
//    @ApiOperation("企业成员列表")
//    @PostMapping("/member/list")
//    @RequiresRoles(value = BizConstants.ROLE_ENTERPRISE_ADMIN)
//    public PageResult<MemberInfoModel>
}
