package com.qkdata.biz.management.service;

import com.google.common.collect.Lists;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.entity.CourseConsumeRecordPO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * 定时任务
 */
@Slf4j
@Service
public class TimeTaskService {

    @Autowired
    @Qualifier("objectRedisTemplate")
    private RedisTemplate redisTemplate;
    @Autowired
    private CourseConsumeRecordService recordService;
    @Autowired
    private ProductOrderService productOrderService;


    /**
     * 每5分钟执行一次
     */
    @Scheduled(cron = "0 0/5 * * * ?")
    public void saveConsumeRecord(){
        log.debug("TimeTaskService saveConsumeRecord excute start=================");
        Set<String> keys = redisTemplate.opsForHash().keys(BizConstants.CACHE_KE_CONSUME_RECORD);
        List<CourseConsumeRecordPO> saveList = Lists.newArrayList();
        for (String key : keys){
            CourseConsumeRecordPO po = (CourseConsumeRecordPO) redisTemplate.opsForHash().get(BizConstants.CACHE_KE_CONSUME_RECORD,key);
            saveList.add(po);
            redisTemplate.opsForHash().delete(BizConstants.CACHE_KE_CONSUME_RECORD,key);
        }
        if (saveList.size() > 0){
            recordService.saveOrUpdateBatch(saveList);
        }
        log.debug("TimeTaskService saveConsumeRecord excute end=================");
    }

    /**
     * 每隔1分名检查未支付订单状态
     */
    @Scheduled(cron = "0 0/1 * * * ?")
    public void checkProductOrder(){
        log.debug("TimeTaskService checkProductOrder excute start=================");
        productOrderService.checkProductOrder();
        log.debug("TimeTaskService checkProductOrder excute end=================");
    }
}
