package com.qkdata.biz.management.vo;

import com.qkdata.biz.enums.CourseAllowEnum;
import com.qkdata.biz.enums.CourseChargeModelEnum;
import com.qkdata.biz.enums.CourseTypeEnum;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class SaveCourseModel {
    private Long id;
    /**
     * 课程名称
     */
    private String name;
    /**
     * 课程类型（单集、系列）
     */
    private CourseTypeEnum type;
    /**
     * 课程简介
     */
    private String introduce;
    /**
     * 课程介绍
     */
    private String detail;
    /**
     * 课程封面url
     */
    private String logoUrl;
    /**
     * 讲师ID
     */
    private Long teacherId;
    /**
     * 讲师名称
     */
    private String teacherName;
    /**
     * 收费模式（免费、会员免费、付费点播）
     */
    private CourseChargeModelEnum chargeModel;
    /**
     * 付费点播普通用户价
     */
    private BigDecimal price;

    /**
     * 付费点播会员价
     */
    private BigDecimal vipPrice;

    /**
     * 有效时间（小时）
     */
    private Integer validPeriod;
    /**
     * 系列ID
     */
    private Long seriesId;
    /**
     * 系列名称
     */
    private String seriesName;
    /**
     * 可见范围（全部、指定企业，指定用户标签）
     */
    private CourseAllowEnum allow;
    /**
     * 指定企业的列表
     */
    private List<Long> allowOrgIds;
    /**
     * 标签列表
     */
    private List<Long> tagIds;
    /**
     * 课程章节列表
     */
    private List<SaveCourseChaperModel> chaperList;
    /**
     * 课程附件列表
     */
    private List<Long> attachmenIds;
    /**
     * 指定的用户标签
     */
    private String userTagIds;
}
