package com.qkdata.biz.web.vo;

import com.qkdata.biz.enums.AccountStatusEnum;
import com.qkdata.biz.enums.AccountTypeEnum;
import com.qkdata.biz.management.entity.UserTagPO;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class FullUserInfo {
    /**
     * 用户ID
     */
    private Long id;
    /**
     * 用户帐号
     */
    private String username;
    /**
     * 昵称
     */
    private String nickName;
    /**
     * 状态
     */
    private AccountStatusEnum status;
    /**
     * 注册时间
     */
    private LocalDateTime createTime;
    /**
     * 最后登陆时间
     */
    private LocalDateTime lastLoginTime;
    /**
     * 激活时间
     */
    private LocalDateTime activateTime;
    /**
     * 姓名
     */
    private String name;
    /**
     * 性别
     */
    private String sex;
    /**
     * 年龄
     */
    private Integer age;
    /**
     * 头像url
     */
    private String avatarUrl;
    /**
     * 用户类型
     */
    private AccountTypeEnum type;
    /**
     * 所属企业ID
     */
    private Long enterpriseId;
    /**
     * 所属企业名称
     */
    private String enterpriseName;
    /**
     * 是否企业管理员
     */
    private boolean enterpriesMgr = false;
    /**
     * vip会员开始时间
     */
    private LocalDateTime vipStartTime;
    /**
     * vip会员结束时间
     */
    private LocalDateTime vipEndTime;
    /**
     * 认证token
     */
    private String authorization;
    /**
     * 用户标签列表
     */
    private List<UserTagPO> userTagList;


}
