package com.qkdata.biz.sms.service;

import com.alipay.api.domain.BizOrderInfo;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.sms.vo.SmsRequest;
import com.qkdata.biz.sms.vo.SmsResponse;
import com.qkdata.biz.sms.vo.SmsV2Condition;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.constants.Constants;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Collections;

@Slf4j
@Service
public class SmsService {

    @Value("${sms.api.v3}")
    private String api;
    @Value("${sms.type}")
    private String smsType;
    /**
     * 登录验证码
     */
    private String smsContent = "SMS_205630239;xak;%s;2";
    /**
     * 验证身份
     */
    private String validateContent = "SMS_205630240;xak;%s;2";


    @Autowired
    private RestTemplate restTemplate;

    public void sendSmsV3(SmsV2Condition condition) {
        if (smsType.equals("tjxak")) {
            try {
                String content = "";
                if (condition.getCode().equals(BizConstants.SMS_TEMPLATE_CODE)){
                    content = String.format(smsContent, condition.getParams().get("code"));
                }else if (condition.getCode().equals(BizConstants.SMS_CHECK_USER_TEMPLATE_CODE)){
                    content = String.format(validateContent, condition.getParams().get("code"));
                }else {
                    throw new BusinessException("短信模板编号不正确");
                }

                content = Base64.getUrlEncoder().encodeToString(content.getBytes("UTF-8"));
                content = URLEncoder.encode(content,"utf-8");
                String url = String.format(api, condition.getMobile(), content);
                log.debug("sms req url:" + url);
                ResponseEntity<String> resp = restTemplate.getForEntity(url, String.class);
                if (resp.getStatusCode() != HttpStatus.OK || !resp.getBody().equals("OK")) {
                    log.error("短信发送失败：{}", resp.getBody());
                    throw new BusinessException("短信发送失败");
                }
            } catch (UnsupportedEncodingException e) {
                log.error(e.getMessage(), e);
                throw new BusinessException("短信发送失败");
            } catch (Throwable e) {
                log.error(e.getMessage(), e);
                throw new BusinessException("短信发送失败");
            }
        }else {
            SmsRequest smsRequest = new SmsRequest(Collections.singletonList(condition));
            SmsResponse smsResponse = restTemplate.postForObject(api, smsRequest, SmsResponse.class);
            if (smsResponse == null || smsResponse.hasError()) {
                log.error("短信发送失败：{}", smsResponse, toString());
                throw new BusinessException("短信发送失败");
            }
        }



    }

}
