package com.qkdata.biz.management.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.qkdata.biz.enums.AnswerTypeEnum;
import com.qkdata.common.base.entity.BasePO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 问题回答表
 * </p>
 *
 * @author liuyang
 * @since 2021-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("answer")
public class AnswerPO extends BasePO {

    private static final long serialVersionUID = 1L;

    /**
     * 问题ID
     */
    private Long questionId;

    /**
     * 回复人ID
     */
    private Long userId;

    /**
     * 区分讲师回复还是用户回复
     */
    private AnswerTypeEnum type;

    /**
     * 内容
     */
    private String content;


}
