package com.qkdata.biz.web.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.web.vo.CourseConsumeRecordModel;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

@Api(tags = "课程消耗记录")
@RestController
@RequestMapping("/api/consumeRecord")
public class CourseConsumeRecordController {
    @Autowired
    @Qualifier("objectRedisTemplate")
    private RedisTemplate redisTemplate;

    @ApiOperation("记录课程消耗记录")
    @PostMapping("/save")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<String> save(@RequestBody CourseConsumeRecordModel model){
        if(redisTemplate.hasKey(model.getUuid())){
            CourseConsumeRecordModel cacheModel = (CourseConsumeRecordModel) redisTemplate.opsForValue().get(model.getUuid());
            cacheModel.setLearnDuration(model.getLearnDuration());
            redisTemplate.opsForValue().set(cacheModel.getUuid(),cacheModel);
        }else {
            model.setStartTime(LocalDateTime.now());
            redisTemplate.opsForValue().set(model.getUuid(),model);
        }
        return Result.succeed("ok");
    }
}
