package com.qkdata.biz.sys.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.qkdata.biz.enums.AccountTypeEnum;
import com.qkdata.biz.enums.UserSexEnum;
import com.qkdata.common.base.entity.BasePO;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户扩展表
 * </p>
 *
 * @author liuyang
 * @since 2021-04-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("user_ext")
public class SysUserExtPO extends BasePO {

    private static final long serialVersionUID = 1L;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 性别
     */
    private UserSexEnum sex;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 头像url
     */
    private String avatarUrl;

    /**
     * 用户类型（普通用户、会员、企业会员）
     */
    private AccountTypeEnum type;

    /**
     * 企业ID
     */
    private Long enterpriseId;

    /**
     * 会员生效时间
     */
    private LocalDateTime vipStartTime;

    /**
     * 会员结束时间
     */
    private LocalDateTime vipEndTime;


}