package com.qkdata.biz.web.vo;

import com.qkdata.common.constants.ValidatorPattern;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Data
public class ModifyMemberInfoModel {
    @NotNull(message = "ID不能为空")
    private Long id;
    private String name;
    @NotBlank(message = "电话不能为空")
    @Pattern(regexp = ValidatorPattern.MOBILE_PATTERN,message = "手机号格式不正确")
    private String username;
    private boolean manager;
}
