package com.qkdata.biz.management.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.enums.QuestionStatusEnum;
import com.qkdata.biz.management.service.QAService;
import com.qkdata.biz.management.vo.*;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "课程问答接口")
@RestController
@RequestMapping("/api/mgr/qa")
public class QAController {
    @Autowired
    private QAService qaService;

    @ApiOperation("查询问题列表")
    @SysLog("查询问题列表")
    @PostMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR,BizConstants.ROLE_TEACHER},logical = Logical.OR)
    public PageResult<QuestionModel> questionList(@RequestBody QueryQuestionModel param){
        return qaService.questionPageList(param);
    }

    @ApiOperation("查看问题回复列表")
    @SysLog("查看问题回复列表")
    @PostMapping("/answerList")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR,BizConstants.ROLE_TEACHER},logical = Logical.OR)
    public PageResult<QAModel> answerList(@RequestBody @Validated QueryAnswerModel param){
        return qaService.answerList(param);
    }

    @ApiOperation("问题回复")
    @SysLog("问题回复")
    @PostMapping("/answer")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR,BizConstants.ROLE_TEACHER},logical = Logical.OR)
    public Result<String> answer(@RequestBody @Validated AnswerModel model){
        qaService.answer(model);
        return Result.succeed("ok");
    }
    @ApiOperation("修改问题状态为已完成")
    @SysLog("修改问题状态为已完成")
    @GetMapping("/question/complete")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR,BizConstants.ROLE_TEACHER},logical = Logical.OR)
    public Result<String> questionComplete(@RequestParam Long questionId){
        qaService.changeQuestionStatus(questionId, QuestionStatusEnum.COMPLETE);
        return Result.succeed("ok");
    }


}
