package com.qkdata.biz.web.controller;

import cn.hutool.core.util.StrUtil;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qkdata.biz.enums.SwiperStatusEnum;
import com.qkdata.biz.management.entity.CourseTagPO;
import com.qkdata.biz.management.entity.TeacherPO;
import com.qkdata.biz.management.service.*;
import com.qkdata.biz.management.vo.CourseDetailModel;
import com.qkdata.biz.management.vo.SwiperConfigModel;
import com.qkdata.biz.management.vo.TeacherModel;
import com.qkdata.biz.web.service.UserCenterService;
import com.qkdata.biz.web.vo.MainPageModel;
import com.qkdata.biz.web.vo.SearchCourseConditionModel;
import com.qkdata.biz.web.vo.SearchCourseResultModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.jwt.JWTService;
import com.qkdata.common.oauth.AuthorizedUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;

@Api(tags = "首页数据获取-手机端")
@RestController
@RequestMapping("/api/web/mainPage")
public class MainPageController {
    @Autowired
    private SwiperConfigService swiperConfigService;
    @Autowired
    private CourseTagService courseTagService;
    @Autowired
    private RecommendConfigService recommendConfigService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private CourseTagService tagService;
    @Autowired
    private UserCenterService userCenterService;
    @Autowired
    private TeacherService teacherService;
    @Autowired
    private JWTService jwtService;

    @ApiOperation("获取配置信息")
    @GetMapping("")
    @SysLog("获取配置信息")
    public Result<MainPageModel> get(){
        List<SwiperConfigModel> swiperConfigModels = swiperConfigService.listConfig(SwiperStatusEnum.ENABLE);
        List<CourseTagPO> tagList = courseTagService.list(Wrappers.<CourseTagPO>lambdaQuery().eq(CourseTagPO::getRecommend,true));
        MainPageModel model = new MainPageModel();
        model.setTags(tagList);
        model.setSwiperConfigs(swiperConfigModels);

        return Result.succeed(model);
    }
    @ApiOperation("首页推存课程列表")
    @PostMapping("/course/recommend/list")
    @SysLog("首页推存课程列表")
    public PageResult<SearchCourseResultModel> recommendCourseList(@RequestBody SearchCourseConditionModel model,HttpServletRequest request) throws IOException {
        return courseService.mainPageRecommendList(model,getUserFromToken(request));
    }
    private AuthorizedUser getUserFromToken(HttpServletRequest request) throws IOException {
        AuthorizedUser authUser = null;
        String token = getRequestToken(request);
        if (StrUtil.isNotBlank(token)){
            DecodedJWT decodedJWT = jwtService.decode(token);
            String userJson = decodedJWT.getClaim("user").asString();
            ObjectMapper mapper = new ObjectMapper();
            authUser = mapper.readValue(userJson,AuthorizedUser.class);
        }
        return authUser;
    }
    /**
     * 获取请求的token
     */
    private String getRequestToken(HttpServletRequest httpRequest){
        //从header中获取token
        String token = httpRequest.getHeader(HttpHeaders.AUTHORIZATION);

        //如果header中不存在token，则从参数中获取token
        if(StringUtils.isEmpty(token)){
            token = httpRequest.getParameter(HttpHeaders.AUTHORIZATION);
        }

        return token;
    }
    @ApiOperation("搜索课程")
    @PostMapping("/course/search")
    @SysLog("搜索课程")
    public PageResult<SearchCourseResultModel> searchCourse(@RequestBody SearchCourseConditionModel model,HttpServletRequest request) throws IOException {
        return courseService.search(model,getUserFromToken(request));
    }

    @ApiOperation("获取全部标签")
    @GetMapping("/course/tags")
    @SysLog("获取全部标签")
    public Result<List<CourseTagPO>> findCourseTags(){
        List<CourseTagPO> tags = tagService.list();
        return Result.succeed(tags);
    }

    @ApiOperation("详情页关联课程推荐")
    @GetMapping("/course/recommend/{courseId}")
    @SysLog("详情页关联课程推荐")
    public Result<List<SearchCourseResultModel>> courseRecommend(Long courseId){
        List<SearchCourseResultModel> list = courseService.relationRecommend(courseId);
        return Result.succeed(list);
    }

    @ApiOperation("获取课程详情")
    @GetMapping("/course/{id}")
    @SysLog("获取课程详情")
    public Result<CourseDetailModel> getCourseDetail(@PathVariable Long id){
//        courseService.checkPerm(id);
        CourseDetailModel model = courseService.getCourseDetail(id);
        return Result.succeed(model);
    }

    @ApiOperation("获取教师信息")
    @GetMapping("/teacher/{teacherId}")
    @SysLog("获取教师信息")
    public Result<TeacherPO> getTeacherInfo(@PathVariable Long teacherId){
        return Result.succeed(teacherService.getById(teacherId));
    }

}
