package com.qkdata.biz.management.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.management.entity.UserTagPO;
import com.qkdata.biz.management.entity.UserTagRelPO;
import com.qkdata.biz.management.mapper.UserTagMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.management.mapper.UserTagRelMapper;
import com.qkdata.biz.management.vo.QueryUserTagModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.model.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * $!{table.comment} 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-09-01
 */
@Service
public class UserTagService extends ServiceImpl<UserTagMapper, UserTagPO> {
    @Autowired
    private UserTagRelMapper userTagRelMapper;

    public PageResult<UserTagPO> queryPageList(QueryUserTagModel params) {
        Page page = new Page(params.getPageIndex(),params.getPageSize());
        List<UserTagPO> list = baseMapper.queryPageList(page,params);
        return PageResult.<UserTagPO>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    public List<UserTagPO> findTagsByUserId(Long userId) {
        return baseMapper.findTagsByUserId(userId);
    }

    public int countByUserTagId(Long tagId) {
        return userTagRelMapper.countByUserTagId(tagId);
    }

    @Transactional
    public void addUserTagRel(Long userId, List<Long> tagIds) {
        userTagRelMapper.delete(Wrappers.<UserTagRelPO>lambdaQuery().eq(UserTagRelPO::getUserId,userId));
        for (Long tagId : tagIds){
            UserTagRelPO po = new UserTagRelPO();
            po.setUserId(userId);
            po.setUserTagId(tagId);
            userTagRelMapper.insert(po);
        }
    }
}