package com.qkdata.biz.management.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.management.entity.CoursePO;
import com.qkdata.biz.management.entity.UserCourseAuthPO;
import com.qkdata.biz.management.mapper.UserCourseAuthMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户课程授权 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-06-03
 */
@Service
public class UserCourseAuthService extends ServiceImpl<UserCourseAuthMapper, UserCourseAuthPO> {

    @Autowired
    private CourseService courseService;
    /**
     * 更新用户课程授权
     * 判断用户课程的授权记录是否存在，不存在：添加，存在：更新期限
     * 更新期限时，判断当前是否过期，未过期：延期处理，已过期：更新新的期限
     * @param userId
     * @param courseId
     * @param startTime 生效时间
     */
    public void updateAuth(Long userId, Long courseId, LocalDateTime startTime) {
        CoursePO coursePO = courseService.getById(courseId);
        if (coursePO != null){
            Integer validPeriod  = coursePO.getValidPeriod();
            UserCourseAuthPO po = getByUserIdAndCourseId(userId,courseId);
            if (po == null){
                po = new UserCourseAuthPO();
                po.setUserId(userId);
                po.setCourseId(courseId);
                po.setStartTime(startTime);
                po.setEndTime(startTime.plusHours(validPeriod));
                save(po);
            }else {
                LocalDateTime now = LocalDateTime.now();
                if (now.isAfter(po.getStartTime()) && now.isBefore(po.getEndTime())){
                    po.setEndTime(po.getEndTime().plusHours(validPeriod));
                }else {
                    po.setStartTime(startTime);
                    po.setEndTime(startTime.plusHours(validPeriod));
                }
                updateById(po);
            }
        }
    }

    private UserCourseAuthPO getByUserIdAndCourseId(Long userId, Long courseId) {
        return getOne(Wrappers.<UserCourseAuthPO>lambdaQuery().eq(UserCourseAuthPO::getUserId,userId).eq(UserCourseAuthPO::getCourseId,courseId));
    }
}