package com.qkdata.biz.management.entity;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.qkdata.biz.enums.OrgTypeEnum;
import com.qkdata.common.base.entity.BasePO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 组织
 * </p>
 *
 * @author liuyang
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("organization")
public class OrganizationPO extends BasePO {

    private static final long serialVersionUID = 1L;

    /**
     * 组织名称
     */
    private String name;

    /**
     * 组织类型（企业、培训机构）
     */
    private OrgTypeEnum type;

    /**
     * 联系人电话
     */
    private String contactTel;

    /**
     * 联系人名称
     */
    private String contactName;

    /**
     * 企业LOG
     */
    private String logoUrl;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 备注
     */
    private String remark;

    /**
     * 删除标识
     */
    @TableLogic
    private Boolean isDel;


}
