package com.qkdata.biz.aliyun.service;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.qkdata.biz.aliyun.config.AliyunConfig;
import com.qkdata.biz.aliyun.vo.AliyunOSSUploadPolicyModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.io.UnsupportedEncodingException;
import java.util.Date;

@Service
public class AliyunService {
    @Autowired
    private AliyunConfig aliyunConfig;
    @Value("${frontend.domain}")
    private String frontendDomain;
    @Value("${server.servlet.context-path}")
    private String serverContextPath;
    private OSS ossClient;
    /**
     * 过期时间（秒）
     */
    private long expireTime = 60;

    @PostConstruct
    private void init(){
        if (ossClient == null){
            ossClient = new OSSClientBuilder().build(aliyunConfig.getEndpoint(),aliyunConfig.getAccessKeyId(),aliyunConfig.getAccessKeySecret());
        }
    }

    public AliyunOSSUploadPolicyModel getUploadPolicy() throws UnsupportedEncodingException {
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConditions = new PolicyConditions();
        policyConditions.addConditionItem(PolicyConditions.COND_CONTENT_LENGTH_RANGE, 0, 1048576000);
        policyConditions.addConditionItem(MatchMode.StartWith, PolicyConditions.COND_KEY, "");

        String postPolicy = ossClient.generatePostPolicy(expiration,policyConditions);
        byte[] binaryData = postPolicy.getBytes("utf-8");
        String encodedPolicy = BinaryUtil.toBase64String(binaryData);
        String postSignature = ossClient.calculatePostSignature(postPolicy);

        AliyunOSSUploadPolicyModel model = new AliyunOSSUploadPolicyModel();
        model.setAccessId(aliyunConfig.getAccessKeyId());
        model.setPolicy(encodedPolicy);
        model.setSignature(postSignature);
        model.setHost("https://" + aliyunConfig.getBucket() + "." + aliyunConfig.getEndpoint());
        model.setExpire(String.valueOf(expireEndTime / 1000));
        model.setDir("");

        JSONObject jsonCallback = new JSONObject();
        jsonCallback.put("callbackUrl",frontendDomain + serverContextPath + "/aliyun/oss/callback");
        jsonCallback.put("callbackBody","{\n" +
                "    \"bucket\": \"${bucket}\",\n" +
                "    \"fileName\": \"${object}\",\n" +
                "    \"etag\": \"${etag}\",\n" +
                "    \"size\": \"${size}\",\n" +
                "    \"mimeType\": \"${mimeType}\",\n" +
                "    \"imageHeight\": \"${imageInfo.height}\",\n" +
                "    \"imageWidth\": \"${imageInfo.width}\",\n" +
                "    \"imageFormat\": \"${imageInfo.format}\"\n" +
                "}");
        jsonCallback.put("callbackBodyType","application/json");
        String base64CallbackBody = BinaryUtil.toBase64String(jsonCallback.toString().getBytes());
        model.setCallback(base64CallbackBody);
        return model;
    }
}
