package com.qkdata.biz.aliyun.controller;

import com.qkdata.biz.aliyun.service.AliyunService;
import com.qkdata.biz.aliyun.vo.AliyunOSSUploadPolicyModel;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.UnsupportedEncodingException;

@Api(tags = "阿里云API")
@RestController
@RequestMapping("/api/aliyun/mgr")
public class AliyunApiController {
    @Autowired
    private AliyunService aliyunService;


    @ApiOperation("获取阿里云OSS上传所需要的参数")
    @GetMapping("/uploadPolicy")
    public Result<AliyunOSSUploadPolicyModel> getUploadPolicy() throws UnsupportedEncodingException {
        return Result.succeed(aliyunService.getUploadPolicy());
    }
}
