package com.qkdata.biz.web.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.enums.CourseAllowEnum;
import com.qkdata.biz.enums.CourseChargeModelEnum;
import com.qkdata.biz.enums.CourseStatusEnum;
import com.qkdata.biz.enums.UserPayRecordTypeEnum;
import com.qkdata.biz.management.entity.CoursePO;
import com.qkdata.biz.management.entity.UserGetVipRecordPO;
import com.qkdata.biz.management.service.CourseService;
import com.qkdata.biz.management.service.UserGetVipRecordService;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.web.vo.FullUserInfo;
import com.qkdata.common.base.entity.BasePO;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.util.UserContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class UserCenterService {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private UserGetVipRecordService userGetVipRecordService;

    /**
     * 验证当前登陆用户是否有播放该课程和章节的权限
     * 课程可见范围是否指定企业，当前用户是否符合
     * 课程收费模式为免费，允许观看
     * 课程收费模式为会员费免，当前用户是否已购买会员，并且在有效期中
     * 课程收费模式为付费点播，当前用户是否已购买该课程，并且在效期中
     * @param courseId
     * @param chaperId
     */
    public void checkCoursePlayPerm(Long courseId, Long chaperId) {
        String username = UserContext.getUser().getUsername();
        Long userId = UserContext.getUserId();
        FullUserInfo userInfo = sysUserService.findFullUserInfo(username);
        CoursePO course = courseService.getById(courseId);
        if (course.getStatus() == CourseStatusEnum.DOWN){
            throw new BusinessException("该课程已下架");
        }
        if (course.getAllow() == CourseAllowEnum.SPECIFY){
            List<Long> orgIds = courseService.getAllowEnterpriseList(courseId);

            boolean allow = false;
            for (Long orgId : orgIds){
                if (userInfo.getEnterpriseId() != null){
                    if (orgId.longValue() == userInfo.getEnterpriseId().longValue()){
                        allow = true;
                        break;
                    }
                }
            }
            if (!allow){
                throw new BusinessException("当前课程指已定企业观看，您不符合条件，请联系客服务人员");
            }
        }
        if (course.getChargeModel() == CourseChargeModelEnum.FREE){
            return;
        }else if (course.getChargeModel() == CourseChargeModelEnum.VIP_FREE){
            if (userInfo.getVipStartTime() == null || userInfo.getVipEndTime() == null){
                throw new BusinessException("您还不是会员，请先成为会员再观看");
            }
            LocalDateTime now = LocalDateTime.now();
            if (!(now.isAfter(userInfo.getVipStartTime()) && now.isBefore(userInfo.getVipEndTime()))){
                throw new BusinessException("您的会员已过期，请续费后再观看");
            }
        }else if (course.getChargeModel() == CourseChargeModelEnum.PAY){
            UserGetVipRecordPO userGetVipRecordPO = userGetVipRecordService.getOne(Wrappers.<UserGetVipRecordPO>lambdaQuery()
                .eq(UserGetVipRecordPO::getUserId,userId)
                .eq(UserGetVipRecordPO::getCourseId,courseId)
                .eq(UserGetVipRecordPO::getType,UserPayRecordTypeEnum.SINGLE_COURSE)
                .orderByDesc(BasePO::getCreateTime)
                .last("limit 1"));
            if (userGetVipRecordPO == null){
                throw new BusinessException("当前课程为付费课程，请购买后再观看");
            }
            Integer validPeriod = course.getValidPeriod();
            LocalDateTime startTime = userGetVipRecordPO.getCreateTime();
            LocalDateTime endTime = startTime.plusHours(validPeriod);
            LocalDateTime now = LocalDateTime.now();
            if (!(now.isAfter(startTime) && now.isBefore(endTime))){
                throw new BusinessException("您购买的该课程已过期，请重新购买");
            }
        }


    }
}
