package com.qkdata.biz.management.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.vod.model.v20170321.GetPlayInfoResponse;
import com.aliyuncs.vod.model.v20170321.GetVideoInfoResponse;
import com.aliyuncs.vod.model.v20170321.GetVideoPlayAuthResponse;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.qkdata.biz.aliyun.service.AliyunService;
import com.qkdata.biz.enums.CourseAllowEnum;
import com.qkdata.biz.enums.CourseChargeModelEnum;
import com.qkdata.biz.enums.CourseModelEnum;
import com.qkdata.biz.enums.CourseStatusEnum;
import com.qkdata.biz.management.entity.*;
import com.qkdata.biz.management.mapper.*;
import com.qkdata.biz.management.vo.*;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.web.vo.FullUserInfo;
import com.qkdata.biz.web.vo.SearchCourseConditionModel;
import com.qkdata.biz.web.vo.SearchCourseResultModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.util.UserContext;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 课程管理 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-05-19
 */
@Service
public class CourseService extends ServiceImpl<CourseMapper, CoursePO> {
    @Autowired
    private AllowOrgCourseMapper allowOrgCourseMapper;
    @Autowired
    private CourseChapterMapper chapterMapper;
    @Autowired
    private CourseSeriesMapper seriesMapper;
    @Autowired
    private CourseTagRelMapper tagRelMapper;
    @Autowired
    private CourseAttachmentMapper attachmentMapper;
    @Autowired
    private CourseTagService tagService;
    @Autowired
    private TeacherService teacherService;
    @Autowired
    private AliyunService aliyunService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SysUserService sysUserService;

    public PageResult<CourseListItemModel> queryPageList(QueryCourseModel param) {
        Page page = new Page(param.getPageIndex(), param.getPageSize());
        List<CourseListItemModel> list = baseMapper.queryPageList(page, param);
        for (CourseListItemModel course : list) {
            List<CourseTagPO> tagsList = tagService.findListByCourseId(course.getId());
            if (CollUtil.isNotEmpty(tagsList)) {
                List<String> tagNameList = tagsList.stream().map(CourseTagPO::getName).collect(Collectors.toList());
                course.setTags(tagNameList);
            }
        }
        return PageResult.<CourseListItemModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

//    @Transactional
//    public Long saveStep1(CourseStep1SaveModel model) {
//        CoursePO po = convertToPO(model);
//        if (po.getId() == null){
//            save(po);
//        }else {
//            updateById(po);
//        }
//
//        if (CollUtil.isNotEmpty(model.getTagIds())){
//            updateCourseTags(po.getId(),model.getTagIds());
//        }
//        if (model.getAllow() == CourseAllowEnum.SPECIFY){
//            updateCourseAllowOrg(po.getId(),model.getAllowOrgIds());
//        }
//        return po.getId();
//    }

//    private void updateCourseAllowOrg(Long id, List<Long> allowOrgIds) {
//        //TODO
//    }
//
//    private void updateCourseTags(Long id, List<Long> tagIds) {
//        //TODO
//    }

//    private CoursePO convertToPO(CourseStep1SaveModel model) {
//        CoursePO po = new CoursePO();
//        po.setId(model.getId());
//        po.setName(model.getName());
//        po.setType(model.getType());
//        po.setIntroduce(model.getIntroduce());
//        po.setDetail(model.getDetail());
//        po.setLogoUrl(model.getLogoUrl());
//        po.setStatus(CourseStatusEnum.UP);
//        po.setTeacherId(model.getTeacherId());
//        po.setChargeModel(model.getChargeModel());
//        if (po.getChargeModel() == CourseChargeModelEnum.PAY) {
//            po.setPrice(model.getPrice());
//            po.setValidPeriod(model.getValidPeriod());
//            po.setVipPrice(model.getVipPrice());
//        }
//        po.setModel(CourseModelEnum.VOD);
//        po.setAllow(model.getAllow());
//        po.setSeriesId(model.getSeriesId());
//        return po;
//    }

//    @Transactional
//    public void saveStep2(CourseStep2SaveModel model) {
//        try {
//            Long resourceId = saveToResource(model.getVideoId());
//            CourseChapterPO po = new CourseChapterPO();
//            po.setCourseId(model.getCourseId());
//            po.setName(model.getChaperName());
//            po.setResourceId(resourceId);
//            po.setSortNo(model.getSortNo());
//            chapterMapper.insert(po);
//        } catch (ClientException e) {
//            throw new BusinessException("获取视频信息错误");
//        }
//
//
//    }
//
//    private Long saveToResource(String videoId) throws ClientException {
//        //根据视频ID，获取视频信息
//        GetVideoInfoResponse videoInfoResponse = aliyunService.getVideoInfo(videoId);
//        Float duration = videoInfoResponse.getVideo().getDuration();
//        Long size = videoInfoResponse.getVideo().getSize();
//        String title = videoInfoResponse.getVideo().getTitle();
//        ResourcePO po = resourceService.getByVideoId(videoId);
//        if (po == null) {
//            po = new ResourcePO();
//        }
//        po.setName(title);
//        po.setSize(size);
//        po.setVideoDuration(duration);
//        resourceService.saveOrUpdate(po);
//        return po.getId();
//    }

    public CourseDetailModel getCourseDetail(Long id) {
        CoursePO po = getById(id);
        if (po == null) {
            throw new BusinessException("请求错误，课程不存在");
        }
        CourseDetailModel model = new CourseDetailModel();
        BeanUtils.copyProperties(po, model);
        addSeriesInfo(model);
        addTeacherInfo(model);
        addTags(model);
        addChaperInfo(model);
        addAttachmentInfo(model);
        addOrgInfo(model);
        return model;
    }

    private void addOrgInfo(CourseDetailModel model) {
        if (model.getAllow() == CourseAllowEnum.SPECIFY){
            List<CourseAllowEnterpriseModel> allowOrgList = baseMapper.selectOrgListByCourseId(model.getId());
            model.setAllowOrgList(allowOrgList);
        }
    }

    private void addAttachmentInfo(CourseDetailModel model) {
        List<CourseAttachmentModel> attachmentModelList = baseMapper.selectAttachmentListByCourseId(model.getId());
        model.setAttachmentList(attachmentModelList);
    }

    private void addChaperInfo(CourseDetailModel model) {
        List<CourseChaperModel> chaperList = chaperList(model.getId());
        model.setChaperList(chaperList);
    }

    private void addTags(CourseDetailModel model) {
        List<CourseTagsModel> tags = tagRelMapper.selectModelList(model.getId());
        model.setTagList(tags);
    }

    private void addSeriesInfo(CourseDetailModel model) {
        CourseSeriesPO po = seriesMapper.selectById(model.getSeriesId());
        if (po != null) {
            model.setSeriesName(po.getName());
        }
    }

    private void addTeacherInfo(CourseDetailModel model) {
        TeacherPO teacherPO = teacherService.getById(model.getTeacherId());
        if (teacherPO != null) {
            model.setTeacherName(teacherPO.getName());
            model.setTeacherAvatar(teacherPO.getAvatarUrl());
            model.setTeacherIntroduce(teacherPO.getIntroduce());
        }
    }

    public void modifyChaperName(ModifyChaperNameModel model) {
        CourseChapterPO po = chapterMapper.selectById(model.getChaperId());
        if (po == null) {
            throw new BusinessException("请求错误，章节不存在");
        }
        po.setName(model.getChaperName());
        chapterMapper.updateById(po);
    }

    @Transactional
    public void delChaper(Long chaperId) {
        CourseChapterPO po = chapterMapper.selectById(chaperId);
        if (po != null) {
            chapterMapper.deleteById(chaperId);
            //删除资源
            ResourcePO resourcePO = resourceService.getById(po.getResourceId());
            if (resourcePO != null){
                resourceService.removeById(po.getResourceId());
            }
            if (StrUtil.isNotBlank(resourcePO.getVideoId())){
                try {
                    aliyunService.removeVideo(resourcePO.getVideoId());
                } catch (ClientException e) {
                    log.error(e.getMessage(),e);
                }
            }

        }


    }

    public void modifyStatus(ModifyCourseStatusModel model) {
        baseMapper.updateStatusById(model.getId(), model.getStatus());
    }

    public List<CourseChaperModel> chaperList(Long courseId) {
        List<CourseChaperModel> list = Lists.newArrayList();
        List<CourseChapterPO> poList = chapterMapper.selectList(Wrappers.<CourseChapterPO>lambdaQuery().eq(CourseChapterPO::getCourseId, courseId).orderByAsc(CourseChapterPO::getSortNo));
        if (CollUtil.isNotEmpty(poList)) {
            for (CourseChapterPO po : poList) {
                CourseChaperModel model = new CourseChaperModel();
                model.setId(po.getId());
                model.setName(po.getName());
                model.setCourseId(po.getCourseId());
                model.setSortNo(po.getSortNo());
                Long resourceId = po.getResourceId();
                setVideoInfo(resourceId, model);
                list.add(model);
            }
        }
        return list;
    }

    private void setVideoInfo(Long resourceId, CourseChaperModel model) {
        ResourcePO resourcePO = resourceService.getById(resourceId);
        if (resourcePO != null) {
            String videoId = resourcePO.getVideoId();
            model.setResourceId(resourceId);
            model.setDuration(resourcePO.getVideoDuration());
            model.setSize(resourcePO.getSize());

            try {
                GetVideoInfoResponse response = aliyunService.getVideoInfo(videoId);
                GetVideoInfoResponse.Video videoInfo = response.getVideo();
                if (videoInfo != null) {
                    if (StrUtil.isNotBlank(videoInfo.getCoverURL())){
                        model.setCoverUrl(videoInfo.getCoverURL());

                    }

                }
            } catch (ClientException e) {
                log.error(e.getMessage(), e);
            }


        }
    }



    public PageResult<CourseSeriesPO> querySeriesPageList(QueryCourseSeriesModel model) {
        Page page = new Page(model.getPageIndex(), model.getPageSize());
        List<CourseSeriesPO> list = seriesMapper.queryPageList(page, model);
        return PageResult.<CourseSeriesPO>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    public Long saveSeries(CourseSeriesPO po) {
        seriesMapper.insert(po);
        return po.getId();
    }

    @Transactional
    public void saveCourse(SaveCourseModel model) {
        Long id = saveOrUpdateCourseBaseInfo(model);
        saveCourseChaper(id, model.getChaperList());
        saveCourseAttachment(id, model.getAttachmenIds());
        saveOrUpdateCourseTags(id, model.getTagIds());
        if (model.getAllow() == CourseAllowEnum.SPECIFY){
            saveOrUpdateOrg(id,model.getAllowOrgIds());
        }

    }

    private void saveOrUpdateOrg(Long courseId, List<Long> allowOrgIds) {
        if (CollUtil.isNotEmpty(allowOrgIds)){
            allowOrgCourseMapper.deleteByCourseId(courseId);
            for (Long orgId : allowOrgIds){
                AllowOrgCoursePO po = new AllowOrgCoursePO();
                po.setCourseId(courseId);
                po.setOrgId(orgId);
                allowOrgCourseMapper.insert(po);
            }
        }
    }

    private void saveOrUpdateCourseTags(Long courseId, List<Long> tagIds) {
        if (CollUtil.isNotEmpty(tagIds)){
            tagRelMapper.deleteByCourseId(courseId);
            for (Long tagId : tagIds){
                CourseTagRelPO po = new CourseTagRelPO();
                po.setCourseId(courseId);
                po.setTagId(tagId);
                tagRelMapper.insert(po);
            }
        }
    }

    private void saveCourseAttachment(Long courseId, List<Long> attachmenIds) {
        if (CollUtil.isNotEmpty(attachmenIds)){
            attachmentMapper.deleteByCourseId(courseId);
            for (Long attachmentId : attachmenIds){
                CourseAttachmentPO po = new CourseAttachmentPO();
                po.setCourseId(courseId);
                po.setResourceId(attachmentId);
                attachmentMapper.insert(po);
            }
        }
    }

    private void saveCourseChaper(Long courseId, List<SaveCourseChaperModel> chaperList) {
        if (CollUtil.isNotEmpty(chaperList)){
            for (SaveCourseChaperModel chaperModel : chaperList){
                Long chaperId = chaperModel.getId();
                if (chaperId == null){
                    //只做章节新增保存
                    ResourcePO resourcePO = new ResourcePO();
                    resourcePO.setName(chaperModel.getName());
                    resourcePO.setVideoId(chaperModel.getVideoId());
                    try {
                        GetVideoInfoResponse videoInfoResponse = aliyunService.getVideoInfo(chaperModel.getVideoId());
                        resourcePO.setSize(videoInfoResponse.getVideo().getSize());
                        resourcePO.setVideoDuration(videoInfoResponse.getVideo().getDuration());
                    } catch (ClientException e) {
                        log.error(e.getMessage(),e);
                    }
                    resourceService.save(resourcePO);
                    CourseChapterPO chapterPO = new CourseChapterPO();
                    chapterPO.setCourseId(courseId);
                    chapterPO.setSortNo(chaperModel.getSortNo());
                    chapterPO.setName(chaperModel.getName());
                    chapterPO.setResourceId(resourcePO.getId());
                    chapterMapper.insert(chapterPO);
                }
            }
        }
    }

    private Long saveOrUpdateCourseBaseInfo(SaveCourseModel model) {
        CoursePO po = new CoursePO();
        po.setId(model.getId());
        po.setName(model.getName());
        po.setType(model.getType());
        po.setIntroduce(model.getIntroduce());
        po.setDetail(model.getDetail());
        po.setLogoUrl(model.getLogoUrl());
        po.setStatus(CourseStatusEnum.UP);
        po.setTeacherId(model.getTeacherId());
        po.setChargeModel(model.getChargeModel());
        if (po.getChargeModel() == CourseChargeModelEnum.PAY) {
            po.setPrice(model.getPrice());
            po.setValidPeriod(model.getValidPeriod());
            po.setVipPrice(model.getVipPrice());
        }
        po.setModel(CourseModelEnum.VOD);
        po.setSeriesId(model.getSeriesId());
        po.setAllow(model.getAllow());
        saveOrUpdate(po);
        return po.getId();
    }

    public VideoInfoModel getVideoInfo(String videoId) throws ClientException {
        VideoInfoModel model = new VideoInfoModel();
        GetVideoInfoResponse response = aliyunService.getVideoInfo(videoId);
        model.setVideoId(videoId);
        model.setSize(response.getVideo().getSize());
        model.setDuration(response.getVideo().getDuration());
        model.setCoverURL(response.getVideo().getCoverURL());
        return model;
    }

    public PageResult<SearchCourseResultModel> search(SearchCourseConditionModel model) {
        Page page = new Page(model.getPageIndex(),model.getPageSize());
        String username = UserContext.getUser().getUsername();
        FullUserInfo userInfo = sysUserService.findFullUserInfo(username);
        List<SearchCourseResultModel> list = baseMapper.searchPageList(page,model,userInfo.getEnterpriseId());
        return PageResult.<SearchCourseResultModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    public List<Long> getAllowEnterpriseList(Long courseId) {
        List<AllowOrgCoursePO> enterpriseIdList = allowOrgCourseMapper.selectList(Wrappers.<AllowOrgCoursePO>lambdaQuery().eq(AllowOrgCoursePO::getCourseId,courseId));
        if (CollUtil.isNotEmpty(enterpriseIdList)){
            return enterpriseIdList.stream().map(AllowOrgCoursePO::getOrgId).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    /**
     * 验证当前登陆用户是否有该课程权限
     * @param courseId
     */
    public void checkPerm(Long courseId) {
        boolean hasPerm = false;
        CoursePO coursePO = getById(courseId);
        if (coursePO == null){
            throw new BusinessException("请求错误，该课程不存在");
        }
        if (coursePO.getStatus() == CourseStatusEnum.DOWN){
            throw new BusinessException("该课程已下架");
        }
        if (coursePO.getAllow() == CourseAllowEnum.SPECIFY){
            List<Long> allowOrgIds = getAllowEnterpriseList(courseId);
            if (CollUtil.isNotEmpty(allowOrgIds)){
                String username = UserContext.getUser().getUsername();
                FullUserInfo userInfo = sysUserService.findFullUserInfo(username);
                if (userInfo.getEnterpriseId() != null){
                    for (Long orgId : allowOrgIds){
                        if (orgId.longValue() == userInfo.getEnterpriseId().longValue()){
                            hasPerm = true;
                            break;
                        }
                    }
                }
            }

        }else {
            hasPerm = true;
        }
        if (!hasPerm){
            throw new BusinessException("对不起，您没权限查看该课程");
        }
    }

    public String getVideoPlayUrl(Long courseId, Long chaperId) {
        CourseChapterPO po = chapterMapper.selectById(chaperId);
        if (po != null){
            ResourcePO resourcePO = resourceService.getById(po.getResourceId());
            if (resourcePO != null && StrUtil.isNotBlank(resourcePO.getVideoId())){
                try {
                    GetPlayInfoResponse response = aliyunService.getVideoPlayInfo(resourcePO.getVideoId());
                    if (CollUtil.isNotEmpty(response.getPlayInfoList())){
                        GetPlayInfoResponse.PlayInfo playInfo = response.getPlayInfoList().get(0);
                        return playInfo.getPlayURL();
                    }
                } catch (ClientException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }
    public GetVideoPlayAuthResponse getVideoPlayAuth(Long courseId,Long chaperId){
        CourseChapterPO po = chapterMapper.selectById(chaperId);
        if (po != null){
            ResourcePO resourcePO = resourceService.getById(po.getResourceId());
            if (resourcePO != null && StrUtil.isNotBlank(resourcePO.getVideoId())){
                try {
                    GetVideoPlayAuthResponse response = aliyunService.getVideoPlayAuth(resourcePO.getVideoId());
                    return response;
                } catch (ClientException e) {
                    throw new BusinessException("获取视频凭证异常");
                }
            }
        }
        return null;
    }

    /**
     * 推荐课程列表
     * 默认推荐4个课程
     * 优先推荐相同系列下的其它课程
     * 如果相同系列下没有其它课程，则随机推荐其它课程
     * 注意过滤指定企业可见范围的课程
     * @return
     */
    public List<RecommendConfigModel> recommend(Long courseId) {
        CoursePO coursePO = getById(courseId);
        if (coursePO != null){
            throw new BusinessException("请求错误，课程不存在");
        }
        List<RecommendConfigModel> resultList = Lists.newArrayList();
        Long seriesId = coursePO.getSeriesId();
        Long enterpriseId = sysUserService.getCurrentUserEnterpriseId();
        List<CoursePO> sameSeriesCourseList = list(Wrappers.<CoursePO>lambdaQuery().eq(CoursePO::getSeriesId,seriesId).eq(CoursePO::getStatus,CourseStatusEnum.UP));
        for (CoursePO course : sameSeriesCourseList){
            if (course.getAllow() == CourseAllowEnum.SPECIFY){
                List<Long> orgIds = getAllowEnterpriseList(courseId);
                boolean hasPerm = false;
                for (Long orgId : orgIds){
                    if (enterpriseId != null){
                        if (orgId.longValue() == enterpriseId.longValue()){
                            hasPerm = true;
                            break;
                        }
                    }
                }
                if (hasPerm){
                    RecommendConfigModel model = new RecommendConfigModel();
                    model.setCourseId(courseId);
                    model.setCourseName(course.getName());
                    model.setCourseLogoUrl(course.getLogoUrl());
                    model.setChargeModel(course.getChargeModel());
                    model.setAllow(course.getAllow());
                    resultList.add(model);
                }else {
                    continue;
                }
            }else {
                RecommendConfigModel model = new RecommendConfigModel();
                model.setCourseId(courseId);
                model.setCourseName(course.getName());
                model.setCourseLogoUrl(course.getLogoUrl());
                model.setChargeModel(course.getChargeModel());
                model.setAllow(course.getAllow());
                resultList.add(model);
            }
            if (resultList.size()  == 4){
                break;
            }
        }
        if (resultList.size() < 4){
            int diff = 4 - resultList.size();
            List<Long> ids = resultList.stream().map(RecommendConfigModel::getCourseId).collect(Collectors.toList());
            List<CoursePO> courseList = list(Wrappers.<CoursePO>lambdaQuery()
                    .notIn(CoursePO::getId,ids)
                    .eq(CoursePO::getStatus,CourseStatusEnum.UP)
                    .last("limit "+diff));
            for (CoursePO course : courseList){
                RecommendConfigModel model = new RecommendConfigModel();
                model.setCourseId(courseId);
                model.setCourseName(course.getName());
                model.setCourseLogoUrl(course.getLogoUrl());
                model.setChargeModel(course.getChargeModel());
                model.setAllow(course.getAllow());
                resultList.add(model);
            }
        }
        for (RecommendConfigModel model : resultList){
            List<CourseTagPO> tagList = tagService.findListByCourseId(model.getCourseId());
            model.setTags(tagList);
            List<CourseChaperModel> chaperList = chaperList(model.getCourseId());
            if (CollUtil.isNotEmpty(chaperList)){
                CourseChaperModel chaperModel = chaperList.get(0);
                ResourcePO resourcePO = resourceService.getById(chaperModel.getResourceId());
                if (resourcePO != null){
                    model.setDuration(resourcePO.getVideoDuration());

                }
            }
        }
        return resultList;
    }

}