package com.qkdata.biz.management.controller;


import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.entity.RecommendConfigPO;
import com.qkdata.biz.management.service.RecommendConfigService;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 推荐课程配置 前端控制器
 * </p>
 *
 * @author liuyang
 * @since 2021-05-27
 */
@Api(tags = "首页推荐配置")
@RestController
@RequestMapping("/api/mgr/recommendConfig")
public class RecommendConfigController {

    @Autowired
    private RecommendConfigService configService;

    @ApiOperation("获取推荐列表")
    @GetMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<List<RecommendConfigPO>> list(){
        return Result.succeed(configService.list());
    }
    @ApiOperation("添加推荐")
    @PostMapping("/add")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> add(@RequestBody RecommendConfigPO po){
        configService.save(po);
        return Result.succeed("ok");
    }
    @ApiOperation("删除推荐")
    @GetMapping("/delete/{id}")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> delete(@PathVariable Long id){
        configService.removeById(id);
        return Result.succeed("ok");
    }
}
