package com.qkdata.common.converter;

import cn.hutool.core.date.DateUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.qkdata.common.base.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.Date;
/**
 * 用于@RequestBody中Date类型参数序列化与反序列化
 */
@Slf4j
public class DateDeserializer extends JsonDeserializer<Date> {
    @Override
    public Date deserialize(JsonParser p, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        try {
            return DateUtil.parseDateTime(p.getValueAsString());
        } catch (Exception e) {
            log.warn("时间转换异常", e);
            throw new BusinessException("时间转换异常");
        }
    }
}
