package com.qkdata.common.annotation;

import java.lang.annotation.*;

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ApiLimit {
    /**
     * 限制某时间段内可以访问的次数，默认设置200
     */
    int limitCounts() default 200;

    /**
     * @return
     * @Description: 限制访问的某一个时间段，单位为秒，默认值10秒
     */
    int timeSecond() default 10;
}
