package com.qkdata.biz.management.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.entity.CourseTagPO;
import com.qkdata.biz.management.service.CourseTagService;
import com.qkdata.biz.management.vo.AddMainPageTagConfigModel;
import com.qkdata.biz.management.vo.QueryCourseTagModel;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "首页标签配置")
@RestController
@RequestMapping("/api/mgr/mainPageTagConfig")
public class MainPageTagConfigController {
    @Autowired
    private CourseTagService tagService;

    @ApiOperation("获取标签待选列表")
    @PostMapping("/tags")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public PageResult<CourseTagPO> tags(@RequestBody QueryCourseTagModel model){
        model.setIncludeRecommend(false);
        return tagService.queryPageList(model);
    }

    @ApiOperation("获取首页标签配置")
    @GetMapping("")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<List<CourseTagPO>> getRemommend(){
        List<CourseTagPO> list = tagService.list(Wrappers.<CourseTagPO>lambdaQuery().eq(CourseTagPO::getRecommend,true));
        return Result.succeed(list);
    }

    @ApiOperation("添加标签")
    @PostMapping("/add")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> add(@RequestBody List<Long> tagIds){
        for (Long tagId : tagIds){
            CourseTagPO po = new CourseTagPO();
            po.setId(tagId);
            po.setRecommend(true);
            tagService.updateById(po);
        }
        return Result.succeed("ok");
    }
    @ApiOperation("删除标签")
    @GetMapping("/delete/{tagId}")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> delete(@PathVariable Long tagId){
        CourseTagPO po = new CourseTagPO();
        po.setId(tagId);
        po.setRecommend(false);
        tagService.updateById(po);
        return Result.succeed("ok");
    }

}
