package com.qkdata.biz.sys.controller;

import com.qkdata.biz.sys.entity.SysLogPO;
import com.qkdata.biz.sys.service.SysLogService;
import com.qkdata.biz.sys.vo.QueryLogModel;
import com.qkdata.common.base.model.PageResult;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "审计日志")
@RestController
@RequestMapping("/api/sys/log")
public class SysLogController {
    @Autowired
    private SysLogService sysLogService;

    @PostMapping("/list")
    public PageResult<SysLogPO> list(@RequestBody QueryLogModel queryLogModel){
        return sysLogService.queryPageList(queryLogModel);
    }
}
