package com.qkdata.biz.sys.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.sys.entity.SysLogPO;
import com.qkdata.biz.sys.service.SysLogService;
import com.qkdata.biz.sys.vo.QueryLogModel;
import com.qkdata.common.base.model.PageResult;
import io.swagger.annotations.Api;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "审计日志")
@RestController
@RequestMapping("/api/sys/log")
public class SysLogController {
    @Autowired
    private SysLogService sysLogService;

    @PostMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public PageResult<SysLogPO> list(@RequestBody QueryLogModel queryLogModel){
        return sysLogService.queryPageList(queryLogModel);
    }
}
