package com.qkdata.biz.sys.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.sys.entity.SysRolePO;
import com.qkdata.biz.sys.service.SysRoleService;
import com.qkdata.biz.sys.vo.QueryRoleModel;
import com.qkdata.biz.sys.vo.SysRoleModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

@Api(tags = "角色管理")
@RestController
@RequestMapping("/api/sys/role")
public class SysRoleController {
    @Autowired
    private SysRoleService sysRoleService;

    /**
     * 角色列表
     */
    @ApiOperation("获取全部角色列表")
    @GetMapping("/select")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN})
    public List<SysRolePO> select(){
        return sysRoleService.list();
    }

    @ApiOperation("查询角色列表")
    @PostMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN})
    public PageResult<SysRolePO> list(@RequestBody QueryRoleModel queryRoleModel){
        return sysRoleService.queryPageList(queryRoleModel);
    }

    @ApiOperation("获取某一角色信息")
    @GetMapping("/info/{id}")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN})
    public Result<SysRoleModel> info(@PathVariable Long id){
        return Result.succeed(sysRoleService.getRoleInfo(id));
    }

    @ApiOperation("保存某一角色信息")
    @SysLog("保存某一角色信息")
    @PostMapping("/save")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN})
    public Result<String> save(@RequestBody @Validated SysRoleModel sysRoleModel){
        sysRoleService.saveRole(sysRoleModel);
        return Result.succeed("ok");
    }

    @ApiOperation("修改某一角色信息")
    @SysLog("修改某一角色信息")
    @PostMapping("/update")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN})
    public Result<String> update(@RequestBody @Validated SysRoleModel sysRoleModel){
        sysRoleService.updateRole(sysRoleModel);
        return Result.succeed("ok");
    }

    @ApiOperation("删除角色信息")
    @SysLog("删除角色信息")
    @PostMapping("/delete")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN})
    public Result<String> delete(@RequestBody Long[] ids){
        sysRoleService.removeByIds(Arrays.asList(ids));
        return Result.succeed("ok");
    }
}
