package com.qkdata.biz.sys.controller;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.sys.service.ShiroService;
import com.qkdata.biz.sys.vo.LoginModel;
import com.qkdata.biz.sys.vo.LoginUserInfo;
import com.qkdata.biz.sys.vo.SysRoleModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api(tags = "系统登陆")
@RestController
@RequestMapping("/api/sys")
public class SysLoginController {
    @Autowired
    private ShiroService shiroService;


    @ApiOperation("登陆")
    @SysLog("登陆")
    @PostMapping("/login")
    public Result<LoginUserInfo> login(@RequestBody @Valid LoginModel loginModel) throws JsonProcessingException {
        LoginUserInfo loginUserInfo = shiroService.login(loginModel.getUsername(),loginModel.getPassword());
        hasPermission(loginUserInfo);
        return Result.succeed(loginUserInfo);
    }

    private void hasPermission(LoginUserInfo loginUserInfo) {
        List<SysRoleModel> roles = loginUserInfo.getRoles();
        if (CollUtil.isEmpty(roles)){
            throw new BusinessException("对不起，您没有权限");
        }
        boolean hasPermission = false;
        for (SysRoleModel role : roles){
            if (role.getCode().equals(BizConstants.ROLE_ADMIN) || role.getCode().equals(BizConstants.ROLE_OPERATOR)){
                hasPermission = true;
                break;
            }
        }
        if (!hasPermission){
            throw new BusinessException("对不起，您没有权限");
        }
    }

    @ApiOperation("登出")
    @SysLog("登出")
    @GetMapping("/logout")
    public Result<String> logout(){
        SecurityUtils.getSubject().logout();
        return Result.succeed("ok");
    }
}
