package com.qkdata.biz.management.service;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.aliyuncs.exceptions.ClientException;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.aliyun.service.AliyunService;
import com.qkdata.biz.management.entity.ResourcePO;
import com.qkdata.biz.management.mapper.ResourceMapper;
import com.qkdata.biz.management.vo.ResourceModel;
import com.qkdata.common.base.exception.BusinessException;
import org.apache.poi.ss.formula.udf.IndexedUDFFinder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;

/**
 * <p>
 * $!{table.comment} 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-04-30
 */
@Service
public class ResourceService extends ServiceImpl<ResourceMapper, ResourcePO> {

    @Autowired
    private AliyunService aliyunService;

    public ResourceModel uploadFile(MultipartFile file) {
        try {
            String originalFileName = file.getOriginalFilename();
            String[] ary = StrUtil.split(originalFileName,StrUtil.DOT);
            String extName = ary.length > 1 ? StrUtil.DOT + ary[1] : "";
            String newFileNaem = generateFileName() +  extName;
            aliyunService.uploadFile(newFileNaem,file.getInputStream());
            //保存ResourcePO
            ResourcePO po = new ResourcePO();
            po.setName(originalFileName);
            po.setUrl(aliyunService.getPublicUrl()+"/"+newFileNaem);
            save(po);
            ResourceModel model = new ResourceModel();
            BeanUtils.copyProperties(po,model);
            return model;
        }catch (Exception e){
            throw new BusinessException("上传文件错误");
        }
    }
    private String generateFileName(){
        return System.currentTimeMillis() + RandomUtil.randomString(4);
    }

    public ResourcePO getByVideoId(String videoId) {
        return getOne(Wrappers.<ResourcePO>lambdaQuery().eq(ResourcePO::getVideoId,videoId));
    }

    @Transactional
    @Override
    public boolean removeById(Serializable id) {
        ResourcePO po = getById(id);
        if (po != null){
            super.removeById(id);
            try {
                aliyunService.removeVideo(po.getVideoId());
            } catch (ClientException e) {
                log.error(e.getMessage(),e);
            }
        }
        return true;
    }
}