package com.qkdata.biz.management.service;

import cn.hutool.core.collection.CollUtil;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.vod.model.v20170321.GetPlayInfoResponse;
import com.aliyuncs.vod.model.v20170321.GetVideoInfoResponse;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.qkdata.biz.aliyun.service.AliyunService;
import com.qkdata.biz.enums.CourseAllowEnum;
import com.qkdata.biz.enums.CourseChargeModelEnum;
import com.qkdata.biz.enums.CourseModelEnum;
import com.qkdata.biz.enums.CourseStatusEnum;
import com.qkdata.biz.management.entity.*;
import com.qkdata.biz.management.mapper.*;
import com.qkdata.biz.management.vo.*;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 课程管理 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-05-19
 */
@Service
public class CourseService extends ServiceImpl<CourseMapper, CoursePO> {
    @Autowired
    private AllowOrgCourseMapper allowOrgCourseMapper;
    @Autowired
    private CourseChapterMapper chapterMapper;
    @Autowired
    private CourseSeriesMapper seriesMapper;
    @Autowired
    private CourseTagRelMapper tagRelMapper;
    @Autowired
    private CourseAttachmentMapper attachmentMapper;
    @Autowired
    private CourseTagService tagService;
    @Autowired
    private TeacherService teacherService;
    @Autowired
    private AliyunService aliyunService;
    @Autowired
    private ResourceService resourceService;

    public PageResult<CourseListItemModel> queryPageList(QueryCourseModel param) {
        Page page = new Page(param.getPageIndex(), param.getPageSize());
        List<CourseListItemModel> list = baseMapper.queryPageList(page, param);
        for (CourseListItemModel course : list) {
            List<CourseTagPO> tagsList = tagService.findListByCourseId(course.getId());
            if (CollUtil.isNotEmpty(tagsList)) {
                List<String> tagNameList = tagsList.stream().map(CourseTagPO::getName).collect(Collectors.toList());
                course.setTags(tagNameList);
            }
        }
        return PageResult.<CourseListItemModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

//    @Transactional
//    public Long saveStep1(CourseStep1SaveModel model) {
//        CoursePO po = convertToPO(model);
//        if (po.getId() == null){
//            save(po);
//        }else {
//            updateById(po);
//        }
//
//        if (CollUtil.isNotEmpty(model.getTagIds())){
//            updateCourseTags(po.getId(),model.getTagIds());
//        }
//        if (model.getAllow() == CourseAllowEnum.SPECIFY){
//            updateCourseAllowOrg(po.getId(),model.getAllowOrgIds());
//        }
//        return po.getId();
//    }

//    private void updateCourseAllowOrg(Long id, List<Long> allowOrgIds) {
//        //TODO
//    }
//
//    private void updateCourseTags(Long id, List<Long> tagIds) {
//        //TODO
//    }

//    private CoursePO convertToPO(CourseStep1SaveModel model) {
//        CoursePO po = new CoursePO();
//        po.setId(model.getId());
//        po.setName(model.getName());
//        po.setType(model.getType());
//        po.setIntroduce(model.getIntroduce());
//        po.setDetail(model.getDetail());
//        po.setLogoUrl(model.getLogoUrl());
//        po.setStatus(CourseStatusEnum.UP);
//        po.setTeacherId(model.getTeacherId());
//        po.setChargeModel(model.getChargeModel());
//        if (po.getChargeModel() == CourseChargeModelEnum.PAY) {
//            po.setPrice(model.getPrice());
//            po.setValidPeriod(model.getValidPeriod());
//            po.setVipPrice(model.getVipPrice());
//        }
//        po.setModel(CourseModelEnum.VOD);
//        po.setAllow(model.getAllow());
//        po.setSeriesId(model.getSeriesId());
//        return po;
//    }

//    @Transactional
//    public void saveStep2(CourseStep2SaveModel model) {
//        try {
//            Long resourceId = saveToResource(model.getVideoId());
//            CourseChapterPO po = new CourseChapterPO();
//            po.setCourseId(model.getCourseId());
//            po.setName(model.getChaperName());
//            po.setResourceId(resourceId);
//            po.setSortNo(model.getSortNo());
//            chapterMapper.insert(po);
//        } catch (ClientException e) {
//            throw new BusinessException("获取视频信息错误");
//        }
//
//
//    }
//
//    private Long saveToResource(String videoId) throws ClientException {
//        //根据视频ID，获取视频信息
//        GetVideoInfoResponse videoInfoResponse = aliyunService.getVideoInfo(videoId);
//        Float duration = videoInfoResponse.getVideo().getDuration();
//        Long size = videoInfoResponse.getVideo().getSize();
//        String title = videoInfoResponse.getVideo().getTitle();
//        ResourcePO po = resourceService.getByVideoId(videoId);
//        if (po == null) {
//            po = new ResourcePO();
//        }
//        po.setName(title);
//        po.setSize(size);
//        po.setVideoDuration(duration);
//        resourceService.saveOrUpdate(po);
//        return po.getId();
//    }

    public CourseDetailModel getCourseDetail(Long id) {
        CoursePO po = getById(id);
        if (po == null) {
            throw new BusinessException("请求错误，课程不存在");
        }
        CourseDetailModel model = new CourseDetailModel();
        BeanUtils.copyProperties(po, model);
        addSeriesInfo(model);
        addTeacherInfo(model);
        addTags(model);
        addChaperInfo(model);
        addAttachmentInfo(model);
        addOrgInfo(model);
        return model;
    }

    private void addOrgInfo(CourseDetailModel model) {
        if (model.getAllow() == CourseAllowEnum.SPECIFY){
            List<CourseAllowEnterpriseModel> allowOrgList = baseMapper.selectOrgListByCourseId(model.getId());
            model.setAllowOrgList(allowOrgList);
        }
    }

    private void addAttachmentInfo(CourseDetailModel model) {
        List<CourseAttachmentModel> attachmentModelList = baseMapper.selectAttachmentListByCourseId(model.getId());
        model.setAttachmentList(attachmentModelList);
    }

    private void addChaperInfo(CourseDetailModel model) {
        List<CourseChaperModel> chaperList = chaperList(model.getId());
        model.setChaperList(chaperList);
    }

    private void addTags(CourseDetailModel model) {
        List<CourseTagsModel> tags = tagRelMapper.selectModelList(model.getId());
        model.setTagList(tags);
    }

    private void addSeriesInfo(CourseDetailModel model) {
        CourseSeriesPO po = seriesMapper.selectById(model.getSeriesId());
        if (po != null) {
            model.setSeriesName(po.getName());
        }
    }

    private void addTeacherInfo(CourseDetailModel model) {
        TeacherPO teacherPO = teacherService.getById(model.getTeacherId());
        if (teacherPO != null) {
            model.setTeacherName(teacherPO.getName());
        }
    }

    public void modifyChaperName(ModifyChaperNameModel model) {
        CourseChapterPO po = chapterMapper.selectById(model.getChaperId());
        if (po == null) {
            throw new BusinessException("请求错误，章节不存在");
        }
        po.setName(model.getChaperName());
        chapterMapper.updateById(po);
    }

    @Transactional
    public void delChaper(Long chaperId) {
        CourseChapterPO po = chapterMapper.selectById(chaperId);
        if (po != null) {
            chapterMapper.deleteById(chaperId);
            //删除资源
            resourceService.removeById(po.getResourceId());
        }


    }

    public void modifyStatus(ModifyCourseStatusModel model) {
        baseMapper.updateStatusById(model.getId(), model.getStatus());
    }

    public List<CourseChaperModel> chaperList(Long courseId) {
        List<CourseChaperModel> list = Lists.newArrayList();
        List<CourseChapterPO> poList = chapterMapper.selectList(Wrappers.<CourseChapterPO>lambdaQuery().eq(CourseChapterPO::getCourseId, courseId).orderByAsc(CourseChapterPO::getSortNo));
        if (CollUtil.isNotEmpty(poList)) {
            for (CourseChapterPO po : poList) {
                CourseChaperModel model = new CourseChaperModel();
                model.setId(po.getId());
                model.setName(po.getName());
                model.setCourseId(po.getCourseId());
                model.setSortNo(po.getSortNo());
                Long resourceId = po.getResourceId();
                setVideoInfo(resourceId, model);
                list.add(model);
            }
        }
        return list;
    }

    private void setVideoInfo(Long resourceId, CourseChaperModel model) {
        ResourcePO resourcePO = resourceService.getById(resourceId);
        if (resourcePO != null) {
            String videoId = resourcePO.getVideoId();
            try {
                GetPlayInfoResponse response = aliyunService.getVideoPlayInfo(videoId);
                List<GetPlayInfoResponse.PlayInfo> playInfoList = response.getPlayInfoList();
                if (CollUtil.isNotEmpty(playInfoList)) {
                    GetPlayInfoResponse.PlayInfo playInfo = playInfoList.get(0);
                    model.setVideoUrl(playInfo.getPlayURL());
                    GetPlayInfoResponse.VideoBase videoBase = response.getVideoBase();
                    model.setSnapshotUrl(videoBase.getCoverURL());
                }
            } catch (ClientException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public PageResult<CourseSeriesPO> querySeriesPageList(QueryCourseSeriesModel model) {
        Page page = new Page(model.getPageIndex(), model.getPageIndex());
        List<CourseSeriesPO> list = seriesMapper.queryPageList(page, model);
        return PageResult.<CourseSeriesPO>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    public void saveSeries(CourseSeriesPO po) {
        seriesMapper.insert(po);
    }

    @Transactional
    public void saveCourse(SaveCourseModel model) {
        Long id = saveOrUpdateCourseBaseInfo(model);
        saveCourseChaper(id, model.getChaperList());
        saveCourseAttachment(id, model.getAttachmenIds());
        saveOrUpdateCourseTags(id, model.getTagIds());
        if (model.getAllow() == CourseAllowEnum.SPECIFY){
            saveOrUpdateOrg(id,model.getAllowOrgIds());
        }

    }

    private void saveOrUpdateOrg(Long courseId, List<Long> allowOrgIds) {
        if (CollUtil.isNotEmpty(allowOrgIds)){
            allowOrgCourseMapper.deleteByCourseId(courseId);
            for (Long orgId : allowOrgIds){
                AllowOrgCoursePO po = new AllowOrgCoursePO();
                po.setCourseId(courseId);
                po.setOrgId(orgId);
                allowOrgCourseMapper.insert(po);
            }
        }
    }

    private void saveOrUpdateCourseTags(Long courseId, List<Long> tagIds) {
        if (CollUtil.isNotEmpty(tagIds)){
            tagRelMapper.deleteByCourseId(courseId);
            for (Long tagId : tagIds){
                CourseTagRelPO po = new CourseTagRelPO();
                po.setCourseId(courseId);
                po.setTagId(tagId);
                tagRelMapper.insert(po);
            }
        }
    }

    private void saveCourseAttachment(Long courseId, List<Long> attachmenIds) {
        if (CollUtil.isNotEmpty(attachmenIds)){
            attachmentMapper.deleteByCourseId(courseId);
            for (Long attachmentId : attachmenIds){
                CourseAttachmentPO po = new CourseAttachmentPO();
                po.setCourseId(courseId);
                po.setResourceId(attachmentId);
                attachmentMapper.insert(po);
            }
        }
    }

    private void saveCourseChaper(Long courseId, List<SaveCourseChaperModel> chaperList) {
        if (CollUtil.isNotEmpty(chaperList)){
            for (SaveCourseChaperModel chaperModel : chaperList){
                Long chaperId = chaperModel.getChaperId();
                if (chaperId == null){
                    //只做章节新增保存
                    ResourcePO resourcePO = new ResourcePO();
                    resourcePO.setName(chaperModel.getChaperName());
                    resourcePO.setVideoId(chaperModel.getVideoId());
                    try {
                        GetVideoInfoResponse videoInfoResponse = aliyunService.getVideoInfo(chaperModel.getVideoId());
                        resourcePO.setSize(videoInfoResponse.getVideo().getSize());
                        resourcePO.setVideoDuration(videoInfoResponse.getVideo().getDuration());
                    } catch (ClientException e) {
                        log.error(e.getMessage(),e);
                    }
                    resourceService.save(resourcePO);
                    CourseChapterPO chapterPO = new CourseChapterPO();
                    chapterPO.setCourseId(courseId);
                    chapterPO.setSortNo(chaperModel.getSortNo());
                    chapterPO.setName(chaperModel.getChaperName());
                    chapterPO.setResourceId(resourcePO.getId());
                    chapterMapper.insert(chapterPO);
                }
            }
        }
    }

    private Long saveOrUpdateCourseBaseInfo(SaveCourseModel model) {
        CoursePO po = new CoursePO();
        po.setId(model.getId());
        po.setName(model.getName());
        po.setType(model.getType());
        po.setIntroduce(model.getIntroduce());
        po.setDetail(model.getDetail());
        po.setLogoUrl(model.getLogoUrl());
        po.setStatus(CourseStatusEnum.UP);
        po.setTeacherId(model.getTeacherId());
        po.setChargeModel(model.getChargeModel());
        if (po.getChargeModel() == CourseChargeModelEnum.PAY) {
            po.setPrice(model.getPrice());
            po.setValidPeriod(model.getValidPeriod());
            po.setVipPrice(model.getVipPrice());
        }
        po.setModel(CourseModelEnum.VOD);
        po.setSeriesId(model.getSeriesId());
        return po.getId();
    }
}