package com.qkdata.biz.management.vo;

import com.qkdata.biz.enums.AnswerTypeEnum;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 问题回复数据对象
 */
@Data
public class QAModel {
    /**
     * 问题ID
     */
    private Long questionId;
    /**
     * 用户或讲师ID
     */
    private Long userId;
    /**
     * 用户或讲师名称
     */
    private String nickName;
    /**
     * 回复类型，用于区用户提问还是讲师回复
     */
    private AnswerTypeEnum type;
    /**
     * 内容
     */
    private String content;
    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
