package com.qkdata.common.oauth;


public enum AuthorizationResponseEnum{

    MISSING_TOKEN("403", "HEADER中不存在TOKEN"),
    INVALID_TOKEN("403", "校验TOKEN失败"),
    EXPIRED_TOKEN("403", "TOKEN已过期"),
    MISSING_CLAIMS("403", "不合法的TOKEN, 信息可能被篡改"),
    INVALID_CLAIM("403", "不合法的TOKEN， 系统中不存在资源");

    private String value;

    private String text;

    AuthorizationResponseEnum(String value, String text) {
        this.value = value;
        this.text = text;
    }

    public String value() {
        return this.value;
    }

    public String text() {
        return this.text;
    }
}
